package com.gingersoft.gsa.cloud.order.order;

import android.text.TextUtils;
import android.util.ArrayMap;

import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.order.bean.request.DeleteOrderRequest;
import com.gingersoft.gsa.cloud.order.bean.response.OrderResponse;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import lombok.Getter;
import lombok.Setter;

/**
 * @作者: bin
 * @創建時間: 2020-10-14
 * @更新時間: 2020-10-14
 * @描述: 堂食訂單
 */
@Getter
@Setter
public class DoshokuOrder extends BaseOrder {

    private volatile static DoshokuOrder doshokuOrder;

    public static DoshokuOrder getInstance() {
        if (doshokuOrder == null) {
            synchronized (DoshokuOrder.class) {
                if (doshokuOrder == null) {
                    doshokuOrder = new DoshokuOrder();
                }
            }
        }
        return doshokuOrder;
    }

    private DoshokuOrder() {
        super();
        initBillStatus(false,false);
    }

    /**
     * 已下單信息
     */
    private OrderResponse orderPlaced;
    /**
     * 開台信息
     */
    private TableBean.DataBean openTableInfo;
    /**
     * 會員信息
     */
    private MemberInfo memberInfo;
    /**
     * 記錄刪除的食品以及原因
     */
    private List<DeleteOrderRequest> deleteMealOrders;
    /**
     * 記錄刪除的折扣Id
     */
    private List<Long> deleteDiscountIds;
    /**
     * 本次送單食品，用於打印
     */
    private List<OrderDetail> newFoodList = new ArrayList<>();
    /**
     * 本次支付方式，用於打印
     */
    private List<PayMethod> billMoney = new ArrayList<>();
    /**
     * 賬單項是否需要更新:會員項，整單折扣項
     */
    private ArrayMap<Integer, String> billItemStatusMap = new ArrayMap<>(2);
    public static final int MEMBER_ITEM_TAG = 10;
    public static final int DISCOUNT_ITEM_TAG = 11;
    private boolean billHasChanged = false;
    /**
     * 記錄修改訂單操作
     * false#送單
     * true#修改訂單
     */
    private boolean modifyOrder = false;

    /**
     * 本次加多少積分
     */
    private float addPoints;
    /**
     * 之前有多少積分
     */
    private float oldPoints;
    /**
     * 現在有多少積分
     */
    private float nowPoints;
    /**
     * 結賬積分QRCode
     */
    private String integralQrcode;


    /**
     * 添加需要刪除的食品
     *
     * @param request
     */
    public void addDeleteMealOrder(DeleteOrderRequest request) {
        getDeleteMealOrders().add(request);
    }

    /**
     * 取消需要刪除的食品
     *
     * @param request
     */
    public void delDeleteMealOrder(DeleteOrderRequest request) {
        getDeleteMealOrders().remove(request);
    }

    public void setDeleteMealOrders(List<DeleteOrderRequest> deleteMealOrders) {
        this.deleteMealOrders = deleteMealOrders;
    }

    public void addDeleteDiscountId(Long id) {
        getDeleteDiscountIds().add(id);
    }

    public Date getOpenTableTime() {
        if (orderPlaced != null && orderPlaced.getCreateTime() != null) {
            return new Date(orderPlaced.getCreateTime());
        }
        return new Date();
    }

    public List<DeleteOrderRequest> getDeleteMealOrders() {
        if (deleteMealOrders == null) {
            deleteMealOrders = new ArrayList<>();
        }
        return deleteMealOrders;
    }

    public List<Long> getDeleteDiscountIds() {
        if (deleteDiscountIds == null) {
            deleteDiscountIds = new ArrayList<>();
        }
        return deleteDiscountIds;
    }

    public void initBillStatus(boolean memberItemStatus, boolean discountItemStatus) {
        billItemStatusMap.put(MEMBER_ITEM_TAG, memberItemStatus + "-" + memberItemStatus);
        billItemStatusMap.put(DISCOUNT_ITEM_TAG, discountItemStatus + "-" + discountItemStatus);
        billHasChanged = false;
    }

    public void setBillItemStatus(int key) {
        String value = billItemStatusMap.get(key);
        String[] status = value.split("-");
        if (status.length == 2) {
            billItemStatusMap.put(key, Boolean.parseBoolean(status[0]) + "-" + !Boolean.parseBoolean(status[1]));
            changeBillStatus();
        }
    }

    public void changeBillStatus() {
        Set<Integer> keySet = billItemStatusMap.keySet();
        Iterator<Integer> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            int key = iterator.next();
            String value = billItemStatusMap.get(key);
            String[] status = value.split("-");
            if (status.length == 2) {
                if (Boolean.parseBoolean(status[0]) != Boolean.parseBoolean(status[1])) {
                    billHasChanged = true;
                    return;
                } else {
                    billHasChanged = false;
                }
            } else {
                billHasChanged = false;
            }
        }
    }

//    public boolean needUpdateMemberInfo() {
//        if (TextUtils.isEmpty(memberUpdateStatus)) {
//            return false;
//        }
//        String[] status = memberUpdateStatus.split("-");
//        if (status.length == 2) {
//            if (Boolean.parseBoolean(status[0]) != Boolean.parseBoolean(status[1])) {
//                return true;
//            } else {
//                return false;
//            }
//        } else {
//            return false;
//        }
//    }

    @Override
    public void initialization() {
        if (deleteMealOrders != null) {
            deleteMealOrders.clear();
        }
        if (deleteDiscountIds != null) {
            deleteDiscountIds.clear();
        }
        if (newFoodList != null) {
            newFoodList.clear();
        }
        if (billMoney != null) {
            billMoney.clear();
        }
        if (billItemStatusMap != null) {
            billItemStatusMap.clear();
            initBillStatus(false,false);
        }
        if (orderPlaced != null) {
            orderPlaced = null;
        }
        if (openTableInfo != null) {
            openTableInfo = null;
        }
        if (memberInfo != null) {
            memberInfo = null;
        }
        billHasChanged = false;
        modifyOrder = false;

        super.initialization();
    }
}
