/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.usb;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.epson.epsonio.DeviceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DevUsb {
    private static final String ACTION_USB_PERMISSION = "com.android.eposprint.USB_PERMISSION";
    private static final int VID_EPSON = 1208;
    private static final int PID_VENDER_CLASS = 514;
    private static final int PID_PRINTER_CLASS_MIN = 3584;
    private static final int PID_PRINTER_CLASS_MAX = 3839;
    private static final String AOA_EPSON = "EPSON";
    private static final String DEFAULT_PRINTER_NAME = "TM Printer";
    private static UsbManager mUsbManager = null;
    private static HashMap<String, UsbDevice> mUsbDeviceList = null;
    private static ArrayList<DeviceInfo> mDeviceInfoList = new ArrayList();
    private static Thread mDiscoverThread = null;
    private static boolean mDiscoverThreadRunning = false;
    private static BroadcastReceiver mUsbReceiver = null;
    private static Context mContext = null;
    private static int mConnectionType = 0;
    private static Integer unregisterReceiverSynchronizer = 0;
    private static final Handler unregisterReceiverCallbackHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (0 == msg.what) {
                Integer n = unregisterReceiverSynchronizer;
                synchronized (n) {
                    mContext.unregisterReceiver(mUsbReceiver);
                    unregisterReceiverSynchronizer.notify();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int start(Context caller, int deviceType, String deviceName) {
        if (259 != deviceType) {
            return 1;
        }
        if (null == caller || null != deviceName) {
            return 1;
        }
        ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
        synchronized (arrayList) {
            mDeviceInfoList.clear();
        }
        mContext = caller;
        if (null == mUsbManager) {
            mUsbManager = (UsbManager)mContext.getSystemService("usb");
        }
        mUsbReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (DevUsb.ACTION_USB_PERMISSION.equals(action)) {
                    Object deviceInfo;
                    String work;
                    boolean bFind;
                    ArrayList arrayList;
                    Intent i;
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                        if (intent.getBooleanExtra("permission", false) && null != device) {
                            i = new Intent();
                            i.putExtra("DEVICE_NAME", device.getDeviceName());
                            i.putExtra("CONNECTION_TYPE", mConnectionType);
                            if (1208 == device.getVendorId() && (514 == device.getProductId() || 3584 <= device.getProductId() && 3839 >= device.getProductId())) {
                                arrayList = mDeviceInfoList;
                                synchronized (arrayList) {
                                    bFind = false;
                                    for (DeviceInfo devInfo : mDeviceInfoList) {
                                        work = devInfo.getDeviceName();
                                        if (!work.equals(device.getDeviceName())) continue;
                                        bFind = true;
                                        break;
                                    }
                                    if (!bFind) {
                                        deviceInfo = new DeviceInfo(259, DevUsb.DEFAULT_PRINTER_NAME, device.getDeviceName(), "", "");
                                        mDeviceInfoList.add(deviceInfo);
                                    }
                                }
                            }
                        }
                    }
                    var4_4 = this;
                    synchronized (var4_4) {
                        UsbAccessory accessory = (UsbAccessory)intent.getParcelableExtra("accessory");
                        if (intent.getBooleanExtra("permission", false) && null != accessory) {
                            i = new Intent();
                            i.putExtra("DEVICE_NAME", accessory.getSerial());
                            i.putExtra("CONNECTION_TYPE", mConnectionType);
                            if (accessory.getManufacturer().equals(DevUsb.AOA_EPSON)) {
                                arrayList = mDeviceInfoList;
                                synchronized (arrayList) {
                                    bFind = false;
                                    for (DeviceInfo devInfo : mDeviceInfoList) {
                                        work = devInfo.getDeviceName();
                                        String serial = accessory.getSerial();
                                        if (null == serial || !work.equals(serial)) continue;
                                        bFind = true;
                                        break;
                                    }
                                    if (!bFind) {
                                        deviceInfo = new DeviceInfo(259, DevUsb.DEFAULT_PRINTER_NAME, accessory.getSerial(), "", "");
                                        mDeviceInfoList.add(deviceInfo);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        };
        try {
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            mContext.registerReceiver(mUsbReceiver, filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        mDiscoverThread = DevUsb.CreateDiscoverThread();
        mDiscoverThreadRunning = true;
        mDiscoverThread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DeviceInfo[] getResult(int[] errStatus, int filterOption) {
        DeviceInfo[] deviceInfoList = null;
        if (null == errStatus || 0 == errStatus.length) {
            return null;
        }
        errStatus[0] = 255;
        if (!mDiscoverThreadRunning) {
            errStatus[0] = 6;
            return null;
        }
        try {
            ArrayList<DeviceInfo> arrayList = mDeviceInfoList;
            synchronized (arrayList) {
                deviceInfoList = mDeviceInfoList.toArray(new DeviceInfo[mDeviceInfoList.size()]);
            }
            errStatus[0] = 0;
        }
        catch (Exception e) {
            errStatus[0] = 5;
        }
        return deviceInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int stop() {
        if (!mDiscoverThreadRunning) {
            return 6;
        }
        mDiscoverThreadRunning = false;
        if (null != mUsbReceiver) {
            if (unregisterReceiverCallbackHandler.getLooper().getThread().getId() != Thread.currentThread().getId()) {
                Integer n = unregisterReceiverSynchronizer;
                synchronized (n) {
                    Message msg = unregisterReceiverCallbackHandler.obtainMessage(0);
                    unregisterReceiverCallbackHandler.sendMessage(msg);
                    try {
                        unregisterReceiverSynchronizer.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            mContext.unregisterReceiver(mUsbReceiver);
        }
        return 0;
    }

    private static Thread CreateDiscoverThread() {
        Thread theThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (mDiscoverThreadRunning) {
                    Iterator deviceIterator;
                    try {
                        mUsbDeviceList = mUsbManager.getDeviceList();
                        deviceIterator = mUsbDeviceList.values().iterator();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    while (deviceIterator.hasNext()) {
                        UsbDevice device = (UsbDevice)deviceIterator.next();
                        if (1208 != device.getVendorId() || 514 != device.getProductId() && (3584 > device.getProductId() || 3839 < device.getProductId())) continue;
                        ArrayList arrayList = mDeviceInfoList;
                        synchronized (arrayList) {
                            boolean bFind = false;
                            for (DeviceInfo devInfo : mDeviceInfoList) {
                                String work = devInfo.getDeviceName();
                                if (!work.equals(device.getDeviceName())) continue;
                                bFind = true;
                                break;
                            }
                            if (!bFind) {
                                DeviceInfo deviceInfo = new DeviceInfo(259, DevUsb.DEFAULT_PRINTER_NAME, device.getDeviceName(), "", "");
                                mDeviceInfoList.add(deviceInfo);
                            }
                        }
                    }
                    UsbAccessory[] usbAccessoryList = mUsbManager.getAccessoryList();
                    if (usbAccessoryList != null) {
                        UsbAccessory usbAccessory = null;
                        for (int i = 0; i < usbAccessoryList.length; ++i) {
                            usbAccessory = usbAccessoryList[i];
                            if (!usbAccessory.getManufacturer().equals(DevUsb.AOA_EPSON)) continue;
                            ArrayList arrayList = mDeviceInfoList;
                            synchronized (arrayList) {
                                boolean bFind = false;
                                for (DeviceInfo devInfo : mDeviceInfoList) {
                                    String work = devInfo.getDeviceName();
                                    String serial = usbAccessory.getSerial();
                                    if (null == serial || !work.equals(serial)) continue;
                                    bFind = true;
                                    break;
                                }
                                if (!bFind) {
                                    DeviceInfo deviceInfo = new DeviceInfo(259, DevUsb.DEFAULT_PRINTER_NAME, usbAccessory.getSerial(), "", "");
                                    mDeviceInfoList.add(deviceInfo);
                                }
                                continue;
                            }
                        }
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        return theThread;
    }
}

