package com.gingersoft.gsa.cloud.base.application;

import android.app.Activity;
import android.content.Context;

import com.billy.cc.core.component.CC;
import com.elvishew.xlog.LogConfiguration;
import com.elvishew.xlog.LogLevel;
import com.elvishew.xlog.XLog;
import com.elvishew.xlog.interceptor.BlacklistTagsFilterInterceptor;
import com.elvishew.xlog.printer.AndroidPrinter;
import com.elvishew.xlog.printer.ConsolePrinter;
import com.elvishew.xlog.printer.Printer;
import com.elvishew.xlog.printer.file.FilePrinter;
import com.elvishew.xlog.printer.file.clean.FileLastModifiedCleanStrategy;
import com.elvishew.xlog.printer.file.naming.DateFileNameGenerator;
import com.gingersoft.gsa.cloud.base.BuildConfig;
import com.gingersoft.gsa.cloud.base.common.bean.CurrentAndroidSetting;
import com.gingersoft.gsa.cloud.base.utils.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.base.utils.constans.UserConstans;
import com.gingersoft.gsa.cloud.base.utils.crash.AppCrashHandler;
import com.gingersoft.gsa.cloud.base.utils.file.FileUtils;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.base.utils.xlog.MyBackupStrategy;
import com.gingersoft.gsa.cloud.database.DaoManager;
import com.jess.arms.base.BaseApplication;

/**
 * Created by Wyh on 2019/12/21.
 */
public class GsaCloudApplication extends BaseApplication {

    /**
     * 系统上下文
     */
    private static GsaCloudApplication mAppContext;
    private Activity mCurrentActivity;
    /**
     * 设置请求超时默认20秒钟 从后台获取超时时间
     */
    public static int REQUEST_TIMEOUT = 20;

    public static boolean isLogin = false;
    public static CurrentAndroidSetting androidSetting;
    public static String userName = "";

    @Override
    public void onCreate() {
        super.onCreate();
        this.mAppContext = this;

        CC.enableVerboseLog(true);
        CC.enableDebug(true);
        CC.enableRemoteCC(true);
        //初始化日誌管理庫
        initXLog();
        initGreenDao();
        AppCrashHandler.getInstance().init(this,"test");

        androidSetting = new CurrentAndroidSetting();
    }

    public Activity getCurrentActivity() {
        return mCurrentActivity;
    }

    public void setCurrentActivity(Activity mCurrentActivity) {
        this.mCurrentActivity = mCurrentActivity;
    }

    private void initXLog() {
        LogConfiguration config = new LogConfiguration.Builder()
                .logLevel(BuildConfig.DEBUG ? LogLevel.ALL             // 指定日志级别，低于该级别的日志将不会被打印，默认为 LogLevel.ALL
                        : LogLevel.NONE)
                .tag("GSA_Cloud_TAG")                                         // 指定 TAG，默认为 "X-LOG"
                .addInterceptor(new BlacklistTagsFilterInterceptor(    // 添加黑名单 TAG 过滤器
                        "blacklist1", "blacklist2", "blacklist3"))
                .build();

        Printer androidPrinter = new AndroidPrinter();             // 通过 android.util.Log 打印日志的打印器
        Printer consolePrinter = new ConsolePrinter();             // 通过 System.out 打印日志到控制台的打印器
        Printer filePrinter = new FilePrinter                      // 打印日志到文件的打印器
                .Builder(FileUtils.ACTIONLOG_PATH)                              // 指定保存日志文件的路径
                .fileNameGenerator(new DateFileNameGenerator())        // 指定日志文件名生成器，默认为 ChangelessFileNameGenerator("log")
                .backupStrategy(new MyBackupStrategy(FileUtils.ACTION_MAX_SIZE))         // 指定日志文件备份策略，默认为 FileSizeBackupStrategy(1024 * 1024)
                .cleanStrategy(new FileLastModifiedCleanStrategy(FileUtils.ACTION_MAX_FILE_TIME))     // 指定日志文件清除策略，默认为 NeverCleanStrategy()
                .build();

        XLog.init(                                                 // 初始化 XLog
                config,                                                // 指定日志配置，如果不指定，会默认使用 new LogConfiguration.Builder().build()
                androidPrinter,                                        // 添加任意多的打印器。如果没有添加任何打印器，会默认使用 AndroidPrinter(Android)/ConsolePrinter(java)
                consolePrinter,
                filePrinter);
    }

    private void initGreenDao() {
        DaoManager mManager = DaoManager.getInstance();
        mManager.init(this);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
    }


    /**
     * 获取系统上下文：用于ToastUtil类
     */
    public static GsaCloudApplication getAppContext() {
        return mAppContext;
    }


    //获取登陆token
    public static String getLoginToken(Context context) {
        return (String) SPUtils.get(context, UserConstans.token, "");
    }

    public static int getMemberId(Context context) {
        return (int) SPUtils.get(context, UserConstans.memberId, 0);
    }

    public static int getBrandId(Context context) {
        return (int) SPUtils.get(context, UserConstans.brandId, 0);
    }

    public static String getBrandName(Context context) {
        return (String) SPUtils.get(context, UserConstans.brandName, "");
    }

    public static int getRestaurantId(Context context) {
        return (int) SPUtils.get(context, UserConstans.restaurantId, 0);
    }

    public static String getRestaurantName(Context context) {
        return (String) SPUtils.get(context, UserConstans.restaurantName, "");
    }

    public static String getMemberName(Context context) {
        return (String) SPUtils.get(context, UserConstans.memberName, "");
    }

    public static String getBrandRestaurantInfos(Context context) {
        return (String) SPUtils.get(context, UserConstans.brandRestaurantInfos, "");
    }

    public static void setLoginToken(Context context, String token) {
        SPUtils.put(context, UserConstans.token, token);
    }

    public static void setMemberId(Context context, int memberId) {
        SPUtils.put(context, UserConstans.memberId, memberId);
    }

    public static void setMemberName(Context context, String memberName) {
        SPUtils.put(context, UserConstans.memberName, memberName);
    }

    public static void setBrandId(Context context, int restaurantId) {
        SPUtils.put(context, UserConstans.brandId, restaurantId);
    }
    public static void setBrandName(Context context, String restaurantName) {
        SPUtils.put(context, UserConstans.brandName, restaurantName);
    }

    public static void setRestaurantId(Context context, int restaurantId) {
        SPUtils.put(context, UserConstans.restaurantId, restaurantId);
    }
    public static void setRestaurantName(Context context, String restaurantName) {
        SPUtils.put(context, UserConstans.restaurantName, restaurantName);
    }
    public static void setBrandRestaurantInfos(Context context, String brandRestaurantIds) {
        SPUtils.put(context, UserConstans.brandRestaurantInfos, brandRestaurantIds);
    }

}
