package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.greendao.FoodModifierDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class FoodModifierDaoUtils {

    private static final String TAG = FoodModifierDaoUtils.class.getSimpleName();
    private DaoManager mManager;
    private Context mContext;

    public FoodModifierDaoUtils(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
        this.mContext = context;
    }

    /**
     * 完成Food记录的插入，如果表未创建，先创建Food表
     *
     * @param foodModifier
     * @return
     */
    public boolean insertCombo(FoodModifier foodModifier) {
        boolean flag = false;
        flag = mManager.getDaoSession().getFoodModifierDao().insert(foodModifier) == -1 ? false : true;
        Log.i(TAG, "insert FoodModifier :" + flag + "-->" + foodModifier.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     *
     * @param foodList
     * @return
     */
    public boolean insertMultFoodModifier(final List<FoodModifier> foodList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (FoodModifier Food : foodList) {
                        mManager.getDaoSession().insertOrReplace(Food);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     *
     * @param foodModifier
     * @return
     */
    public boolean updateFoodModifier(FoodModifier foodModifier) {
        boolean flag = false;
        try {
            mManager.getDaoSession().update(foodModifier);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     *
     * @param food
     * @return
     */
    public boolean deleteFoodModifier(FoodModifier food) {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(food);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     *
     * @return
     */
    public boolean deleteAll() {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(FoodModifier.class);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     *
     * @return
     */
    public List<FoodModifier> queryAllFoodModifier() {
        return mManager.getDaoSession().loadAll(FoodModifier.class);
    }

    /**
     * 根据主键id查询记录
     *
     * @param key
     * @return
     */
    public FoodModifier queryFoodModifierById(long key) {
        return mManager.getDaoSession().load(FoodModifier.class, key);
    }


    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public List<Modifier> queryModifiersByQueryBuilder(long fid) {
        List<FoodModifier> foodModifiers = queryFoodModifiersByMidQueryBuilder(fid);
        List<Modifier> list = new ArrayList<>();
        ModifierDaoUtils modifierDao = new ModifierDaoUtils(mContext);
        if (foodModifiers != null) {
            for (int i = 0; i < foodModifiers.size(); i++) {
//                Modifier modifier = modifierDao.queryModifierByQueryBuilder(foodModifiers.get(i).getMid());
//                List<Modifier> modifiers = foodModifiers.get(i).getModifiers();
//                if (modifiers != null) {
////                    modifier.setFid(fid);
//                    list.addAll(modifiers);
//                }
            }
        }

        return list;
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<FoodModifier> queryFoodModifierByNativeSql(String sql, String[] conditions) {
        return mManager.getDaoSession().queryRaw(FoodModifier.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public FoodModifier queryFoodModifierByQueryBuilder(long fid) {
        QueryBuilder<FoodModifier> queryBuilder = mManager.getDaoSession().queryBuilder(FoodModifier.class);
        return queryBuilder.where(FoodModifierDao.Properties.Fid.eq(fid)).build().unique();
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public List<FoodModifier> queryFoodModifiersByMidQueryBuilder(long fid) {
        QueryBuilder<FoodModifier> queryBuilder = mManager.getDaoSession().queryBuilder(FoodModifier.class);
        return queryBuilder.where(FoodModifierDao.Properties.Fid.eq(fid)).list();
    }
}
