package com.gingersoft.gsa.cloud.base.common.bean;

import android.graphics.Color;

import com.gingersoft.gsa.cloud.database.bean.Discount;

import lombok.Data;


/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-19
 * 修订历史：2020-01-19
 * 描述：
 */
@Data
public class BillOrderMoney {

    private String title;
    private double money;

    private int textSize;
    private int textColor = Color.parseColor("#000000");
    private int bgColor;

    /**是否已送單#0=未送單;1=已送單*/
    private int status = 0;
    public static final byte BILL_ITEM_NO_ORDER_STATUS = 0;
    public static final byte BILL_ITEM_ORDER_SENT_STATUS = 1;


    private byte type = ORDER_DISCOUNT_TYPE;
    /**整單折扣*/
    public static final byte ORDER_DISCOUNT_TYPE = 0;
    /**會員等級折扣*/
    public static final byte MEMBER_DISCOUNT_TYPE = 1;
    /**會員優惠券折扣*/
    public static final byte COUPON_DISCOUNT_TYPE = 2;
    /**服務費*/
    public static final byte SERVERCHARGE_TYPE = 3;
    /**賬單小數*/
    public static final byte ROUNDING_TYPE = 4;

    /**折扣實體*/
    private Discount discount;

    public BillOrderMoney() {
    }

    public BillOrderMoney(String title, double money, int textSize, int textColor, int bgColor) {
        this.title = title;
        this.money = money;
        this.textSize = textSize;
        this.textColor = textColor;
        this.bgColor = bgColor;
    }

    public BillOrderMoney(String title, double money) {
        this.title = title;
        this.money = money;
    }

}


