package com.gingersoft.gsa.delivery_pick_mode.ui.adapter

import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtil
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.ServiceChargeRecordBean

class ThirdExpensesAdapter(data: MutableList<ServiceChargeRecordBean.DataX>?) : BaseQuickAdapter<ServiceChargeRecordBean.DataX, BaseViewHolder>(R.layout.item_third_expenses, data) {

    override fun convert(holder: BaseViewHolder, item: ServiceChargeRecordBean.DataX) {
        if (holder.adapterPosition == 0) {
            holder.setText(R.id.tv_third_expenses_user, "追加人")
            holder.setText(R.id.tv_third_expenses_time, "追加時間")
            holder.setText(R.id.tv_third_expenses_amount, "金額")
        } else {
            holder.setText(R.id.tv_third_expenses_user, "" + item.updateName)
            holder.setText(R.id.tv_third_expenses_time, TimeUtil.StampToData(TimeUtil.dateFormatYMDHMS, item.updateTime))
            holder.setText(R.id.tv_third_expenses_amount, "+$" + item.paymentValue)
        }
    }
}