package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseOrderRespose;
import com.gingersoft.gsa.cloud.base.common.bean.table.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableDetail;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderService;
import com.gingersoft.gsa.cloud.table.mvp.model.service.TableService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.TableContract;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class TableModel extends BaseModel implements TableContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public TableModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public List<Food> queryDB_AllFoodList() {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryAllFoodByQueryBuilder();
        return foods;
    }

    @Override
    public List<Modifier> queryDB_ModifierList(long fid, int mode) {
        ModifierDaoUtils daoUtils = new ModifierDaoUtils(mApplication);
        return daoUtils.queryModifiersByFid(fid, mode);
    }

    @Override
    public Observable<TableBean> getTables(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getTables(restaurantId);
    }

    @Override
    public Observable<TableDetail> getTable(int tableId,String tableNumber) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getTable(tableId,tableNumber);
    }

    @Override
    public Observable<BaseOrderRespose> getOrderById(long orderId) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .getOrderById(orderId);
    }

    @Override
    public Observable<BaseOrderRespose> openTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .openTable(requestBody);
    }

    @Override
    public Observable<BaseOrderRespose> turnTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .turnTable(requestBody);
    }

    @Override
    public Observable<BaseOrderRespose> initTable(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .initTable(requestBody);
    }

    @Override
    public Observable<BaseResult> getSplitTables(int tableId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .getSplitTables(tableId);
    }

    @Override
    public Observable<BaseResult> splitTable(int tableId) {
        return mRepositoryManager.obtainRetrofitService(TableService.class)
                .splitTable(tableId);
    }


}