package com.gingersoft.gsa.cloud.table.mvp.model.bean;

import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.common.bean.OrderBean;
import com.gingersoft.gsa.cloud.base.common.bean.discount.OrderDiscount;
import com.gingersoft.gsa.cloud.base.common.bean.table.TableBean;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-14
 * 修订历史：2020-03-14
 * 描述：已結賬訂單
 */
@Data
public class OrderDetailItem implements Serializable {

    /**
     * success : true
     * sysTime : 1584168902700
     * data : [{"id":47040,"orderNo":"gs200371144969589","status":0,"totalAmount":10,"totalPoints":0,"createTime":"Mar 14, 2020 1:24:12 PM","person":2,"orderDetails":[{"id":1639952,"orderId":47040,"parentId":0,"productName":"包子","productId":"14520","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639953,"orderId":47040,"parentId":0,"productName":"燒麥","productId":"14522","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47039,"orderNo":"gs200741188764794","status":4,"totalAmount":1015,"totalPoints":0,"createTime":"Mar 14, 2020 1:18:32 PM","person":5,"orderDetails":[{"id":1639951,"orderId":47039,"parentId":0,"productName":"餃子","productId":"14521","price":10,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639956,"orderId":47039,"parentId":0,"productName":"火鍋","productId":"14527","price":200,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639957,"orderId":47039,"parentId":1639956,"productName":"加醋","productId":"8563","price":1,"lunchboxPrice":0,"number":5,"type":4,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639958,"orderId":47039,"parentId":1639956,"productName":"青菜","productId":"965","price":0,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47038,"orderNo":"gs200451176160673","status":4,"totalAmount":3325,"totalPoints":0,"createTime":"Mar 14, 2020 1:08:44 PM","person":5,"orderDetails":[{"id":1639946,"orderId":47038,"parentId":0,"productName":"壽司","productId":"14534","price":20,"lunchboxPrice":0,"number":50,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639947,"orderId":47038,"parentId":1639946,"productName":"加牛肉","productId":"8566","price":20,"lunchboxPrice":0,"number":50,"type":4,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639948,"orderId":47038,"parentId":1639946,"productName":"木頭飯","productId":"963","price":25,"lunchboxPrice":0,"number":50,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639949,"orderId":47038,"parentId":0,"productName":"餃子","productId":"14521","price":10,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639950,"orderId":47038,"parentId":0,"productName":"燒麥","productId":"14522","price":5,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47037,"orderNo":"gs200001100863294","status":4,"totalAmount":162555,"totalPoints":0,"createTime":"Mar 14, 2020 1:00:45 PM","person":2,"orderDetails":[{"id":1639940,"orderId":47037,"parentId":0,"productName":"雞米花","productId":"14536","price":20,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639941,"orderId":47037,"parentId":0,"productName":"奶茶-顯示","productId":"14532","price":15,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639942,"orderId":47037,"parentId":0,"productName":"壽司","productId":"14534","price":1000,"lunchboxPrice":0,"number":50,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639943,"orderId":47037,"parentId":1639942,"productName":"加牛肉","productId":"8566","price":1000,"lunchboxPrice":0,"number":50,"type":4,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639944,"orderId":47037,"parentId":1639942,"productName":"木頭飯","productId":"963","price":1250,"lunchboxPrice":0,"number":50,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639945,"orderId":47037,"parentId":0,"productName":"西紅柿蛋湯","productId":"14526","price":20,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47036,"orderNo":"gs201841108269516","status":4,"totalAmount":15,"totalPoints":0,"createTime":"Mar 14, 2020 12:59:26 PM","person":2,"orderDetails":[{"id":1639938,"orderId":47036,"parentId":0,"productName":"餃子","productId":"14521","price":10,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639939,"orderId":47036,"parentId":0,"productName":"燒麥","productId":"14522","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47035,"orderNo":"gs200511160960157","status":4,"totalAmount":502500,"totalPoints":0,"createTime":"Mar 14, 2020 12:43:10 PM","person":2,"orderDetails":[{"id":1639935,"orderId":47035,"parentId":0,"productName":"火鍋","productId":"14527","price":10000,"lunchboxPrice":0,"number":50,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639936,"orderId":47035,"parentId":1639935,"productName":"加醋","productId":"8563","price":50,"lunchboxPrice":0,"number":50,"type":4,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639937,"orderId":47035,"parentId":1639935,"productName":"青菜","productId":"965","price":0,"lunchboxPrice":0,"number":50,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47034,"orderNo":"gs201081124266644","status":4,"totalAmount":20,"totalPoints":0,"createTime":"Mar 14, 2020 12:41:22 PM","person":2,"orderDetails":[{"id":1639932,"orderId":47034,"parentId":0,"productName":"包子","productId":"14520","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639933,"orderId":47034,"parentId":0,"productName":"燒麥","productId":"14522","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639934,"orderId":47034,"parentId":0,"productName":"餃子","productId":"14521","price":10,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47033,"orderNo":"gs200771176264819","status":4,"totalAmount":1005,"totalPoints":0,"createTime":"Mar 14, 2020 12:27:24 PM","person":5,"orderDetails":[{"id":1639929,"orderId":47033,"parentId":0,"productName":"火鍋","productId":"14527","price":200,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639930,"orderId":47033,"parentId":1639929,"productName":"加醋","productId":"8563","price":1,"lunchboxPrice":0,"number":5,"type":4,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639931,"orderId":47033,"parentId":1639929,"productName":"青菜","productId":"965","price":0,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47029,"orderNo":"gs200551108069942","status":4,"totalAmount":1055,"totalPoints":0,"createTime":"Mar 14, 2020 12:17:27 PM","person":5,"orderDetails":[{"id":1639912,"orderId":47029,"parentId":0,"productName":"餃子","productId":"14521","price":10,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639913,"orderId":47029,"parentId":0,"productName":"火鍋","productId":"14527","price":200,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639914,"orderId":47029,"parentId":1639913,"productName":"加醋","productId":"8563","price":1,"lunchboxPrice":0,"number":5,"type":4,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639915,"orderId":47029,"parentId":1639913,"productName":"青菜","productId":"965","price":0,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]},{"id":47028,"orderNo":"gs200441188067145","status":4,"totalAmount":330,"totalPoints":0,"createTime":"Mar 14, 2020 12:11:34 PM","person":5,"orderDetails":[{"id":1639908,"orderId":47028,"parentId":0,"productName":"拉麵","productId":"14529","price":50,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639909,"orderId":47028,"parentId":1639908,"productName":"牛奶","productId":"964","price":5,"lunchboxPrice":0,"number":5,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639910,"orderId":47028,"parentId":0,"productName":"拉麵","productId":"14529","price":50,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639911,"orderId":47028,"parentId":1639910,"productName":"牛奶","productId":"964","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]}]
     */

    /**
     * id : 47040
     * tableName : 4
     * tableId : 1694
     * orderNo : gs200371144969589
     * status : 0
     * totalAmount : 10
     * totalPoints : 0
     * amount : 15
     * createTime : Mar 14, 2020 1:24:12 PM
     * endTime : Mar 14, 2020 1:24:12 PM
     * person : 2
     * payName : 支付寶
     * orderPayType : 0
     * tipsPrice : 5
     * linePayType : 1
     * orderDetails : [{"id":1639952,"orderId":47040,"parentId":0,"productName":"包子","productId":"14520","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639953,"orderId":47040,"parentId":0,"productName":"燒麥","productId":"14522","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]
     */
    private long id;
    private int status;
    private String orderNo;
    private String tableName;
    private int tableId;
    private int person;
    /**
     * 订单类型
     * 1：堂食
     * 2：外賣
     * 3：掃碼點餐
     * 5：預點餐
     * 7：自取
     */
    private int orderType;
    /**總金額*/
    private double totalAmount;
    private int totalPoints;
    /**支付金額*/
    private double amount;
    /**賬單小數*/
    private Double rounding;
    /**服務費*/
    private Double serviceAmount;
    /**訂單碼*/
    private String billNo;
    /**取餐碼*/
    private String takeFoodCode;

    /**生成訂單時間*/
    private String createTime;
    /**結賬時間*/
    private String endTime;

    /**訂單食品詳情*/
    private List<OrderBean.OrderDetailsBean> orderDetails;
    /**折扣詳情*/
    private List<OrderDiscount.Respose> discountDetails;
    /**支付詳情*/
    private List<OrderPayBean> orderPays;
    /**餐檯信息*/
    private TableBean.DataBean restaurantTable;
    /**會員信息*/
    private MemberInfo memberInfo;
    /**會員積分碼*/
    private String verifyCode;
    /**會員積分相关实体*/
    private OrderPayRespose integralInfo;


    /**
     * 訂單狀態:0:未支付;1:待確認(已支付, 待餐廳確認);2:制作中（餐厅确认）;3:派送中;4:确认收货（完成）;5:是否评论;6:取消;
     */
    public static final byte STATUS_UNPAID = 0;
    public static final byte STATUS_NOT_CONFIRM = 1;
    public static final byte STATUS_Making = 2;
    public static final byte STATUS_Dispatching = 3;
    public static final byte STATUS_CONFIRM = 4;
    public static final byte STATUS_COMMENT = 5;
    public static final byte STATUS_CANCEL = 6;


    /**
     * 订单类型1：堂食2：外賣3：掃碼點餐5：預點餐7：自取
     */
    public static final byte ORDER_TYPE_DOSHOKU = 1;
    public static final byte ORDER_TYPE_TAKEAWAY = 2;
    public static final byte ORDER_TYPE_SELFCOLLECTION = 7;

    @Data
    public static final class OrderPayBean implements Serializable{
        private long id;
        private long lineOrderId;
        private int payType;
        private String payTime;
        private double amount;
        private double tipsPrice;
        private int status;
        private int linePayType;
        private double paySales;
        private String payName;
    }

}
