package com.gingersoft.gsa.cloud.table.mvp.model.table.action;

import android.content.Context;

import com.gingersoft.gsa.cloud.base.common.bean.table.TableBean;
import com.gingersoft.gsa.cloud.table.R;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-23
 * 修订历史：2020-09-23
 * 描述：餐檯模式-打印上菜紙{@link com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity}
 */
public class PrintServingPaperAction extends TableAction {


    public PrintServingPaperAction(Context context) {
        super(context, "上菜紙", "請選擇檯號", "");
    }

    @Override
    public void action(TableBean.DataBean dataBean) {
        setOperatContentText(dataBean.getTableName());
        if (dataBean.getSplitStatus() == 1) {
            showSplitTableDialogAction();
        } else {
            showActionTipDialog(dataBean);
        }
    }

    @Override
    public boolean filterTableCondition(TableBean.DataBean dataBean) {
        return dataBean.getStatus() != 0;
    }

    public void showActionTipDialog(TableBean.DataBean dataBean) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(mContext);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage("是否確認打印");
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                dialog.dismiss();
                loadOrderToPrint(dataBean);
            }
        });
        dialogBuilder.addAction("取消", new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                dialog.dismiss();
                cancel();
            }
        });
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }
}
