package com.gingersoft.gsa.cloud.base.common.bean.mealManger;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.common.bean.DeleteOrderRequest;
import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.common.bean.OrderBean;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019/9/17
 * 修订历史：2019/9/17
 * 描述：
 */
public class MyOrderManage {

    private static MyOrderManage myOrderManage;
    /**
     * 外賣接單
     */
    private static OrderDetails.DataBean dataBean;

    public static MyOrderManage getInstance() {
        if (myOrderManage == null) {
            myOrderManage = new MyOrderManage();
        }
        return myOrderManage;
    }

//    private ShopCart shopCart;

    private boolean overMaxQty = false;
    private int Languageindex;
    private boolean Edit_Send = false;
    private int selpostion = 0;

    private int selstartpostion = 0;
    private int selendpostion = 0;
    private int selmainstartpositon = 0;
    private int selmainendpostion = 0;
    private int select_Full_start_position = 0;
    private int select_Full_end_position = 0;

    private int seqno = 1; //一级序
    private int sseq = 0;//二级序
    private int mseq = 0;//三级序


    private OrderBean orderBean;

    /**
     * 會員信息
     */
    private MemberInfo memberInfo;
    /**
     * 食品列表
     */
    private List<OrderDetail> orderFoodList = new ArrayList<>();
    /**
     * 本次送單食品，用於打印
     */
    private List<OrderDetail> newFoodList = new ArrayList<>();
    /**
     * 記錄刪除的食品以及原因
     */
    private List<DeleteOrderRequest> deleteOrders;
    /**
     * 整單折扣，服務費
     */
    protected List<BillOrderMoney> orderMoneyList = new ArrayList<>();
    /**
     * 本次支付方式，用於打印
     */
    private List<PayMethod> billMoney = new ArrayList<>();
    /**
     * 合計
     */
    private double wholeAmount = 0.0;
    /**
     * 總金額
     */
    private double totalAmount = 0.0;

    /**
     * 本次加多少積分
     */
    private float addPoints;
    /**
     * 之前有多少積分
     */
    private float oldPoints;
    /**
     * 現在有多少積分
     */
    private float nowPoints;
    /**
     * 結賬積分QRCode
     */
    private String integralQrcode;


    /**
     * 記錄修改訂單操作
     * false#送單
     * true#修改訂單
     */
    private boolean modifyOrder = false;

    public long getOrderId() {
        if (orderBean != null) {
            return orderBean.getId();
        }
        return -1;
    }

    public String getOrderNo() {
        if (orderBean != null) {
            return orderBean.getOrderNo();
        }
        return "";
    }

    public int getOrderStatus() {
        if (orderBean != null) {
            return orderBean.getStatus();
        }
        return 0;
    }

    public Date getOpenTableTime() {
        if (orderBean != null && orderBean.getCreateTime() != null) {
            return new Date(orderBean.getCreateTime());
        }
        return new Date();
    }

    public void setOrderId(double orderId) {
        if (orderBean == null) {
            orderBean = new OrderBean();
        }
        if (orderBean != null) {
            orderBean.setId((long) orderId);
        }
    }

    public void setOrderBean(OrderBean orderBean) {
        this.orderBean = orderBean;
    }

    public OrderBean getOrderBean() {
        return orderBean;
    }

    public MemberInfo getMemberInfo() {
        return memberInfo;
    }

    public void setMemberInfo(MemberInfo memberInfo) {
        this.memberInfo = memberInfo;
    }

    public List<DeleteOrderRequest> getDeleteOrders() {
        if (deleteOrders == null) {
            deleteOrders = new ArrayList<>();
        }
        return deleteOrders;
    }

    public void setDeleteOrders(List<DeleteOrderRequest> deleteOrders) {
        this.deleteOrders = deleteOrders;
    }

    public void addDeleteOrder(DeleteOrderRequest orderRequest){
        getDeleteOrders().add(orderRequest);
    }

    public void changeNumber(int number) {

        if (orderFoodList.size() <= 0) {
            return;
        }
        if (this.selmainstartpositon > orderFoodList.size()) {
            return;
        }

//        OrderDetail orderFood = orderFoodList.get(this.select_Full_start_position);
        OrderDetail orderFood = orderFoodList.get(this.select_Full_start_position);
        OrderDetail orderMainFood = orderFoodList.get(this.selmainstartpositon);

        int qty = orderFood.getNumber();

        boolean intQty = number == 1 || qty == 1 || number < qty;

        change_food_number(orderFood, number);
        change_child_number(orderFood, orderMainFood, number);

        if (intQty) {
//            if (number != 1 && number < qty) {
//                //從大到小直接抹掉細項
//                removeFoodModifify(orderFood);
//            }
//            change_child_number(orderFood, number);
        }
    }

    private void change_food_number(OrderDetail orderFood, int number) {
        String currentMaxNumber = orderFood.getCurrentMaxNumber();
        if (!TextUtils.isEmpty(currentMaxNumber)) {
            if (number > Integer.parseInt(currentMaxNumber)) {
                showSoldDialog(orderFood);
                orderFood.setNumber(Integer.parseInt(currentMaxNumber));
            } else {
                orderFood.setNumber(number);
            }
        } else {
            orderFood.setNumber(number);
        }
        setCalculatePrice(orderFood);
    }

    private void change_child_number(OrderDetail orderFood, OrderDetail orderMainFood, int number) {
        int parentIndex = orderFood.getMyIndex();
        int mainNumber = orderMainFood.getNumber();
        if (orderMainFood.getItemType() == 1 && mainNumber == 1) {
            //主食品金额为1 子食品金额也为1
            for (int i = select_Full_start_position; i <= select_Full_end_position; i++) {
                OrderDetail datasBean = orderFoodList.get(i);
                if (datasBean.getParentIndex() == parentIndex) {
                    datasBean.setNumber(1);
                    setCalculatePrice(datasBean);
                }
            }
        } else {
            for (int i = select_Full_start_position; i <= select_Full_end_position; i++) {
                OrderDetail datasBean = orderFoodList.get(i);
                if (datasBean.getParentIndex() == parentIndex) {
//                    if (datasBean.getNumber() == 1) {
                    String currentMaxNumber = datasBean.getCurrentMaxNumber();
                    if (!TextUtils.isEmpty(currentMaxNumber)) {
                        if (number > Integer.parseInt(currentMaxNumber)) {
                            datasBean.setNumber(Integer.parseInt(currentMaxNumber));
                        } else {
                            datasBean.setNumber(number);
                        }
                    } else {
                        datasBean.setNumber(number);
                    }
//                    datasBean.setNumber(number);
                    setCalculatePrice(datasBean);
//                    }
                }
            }
        }
    }

    private void showSoldDialog(OrderDetail orderDetail) {
        String msg = "[" + orderDetail.getProductName() + "]" + "已售罄";
        CommonTipDialog.showSurpisedDialog(GsaCloudApplication.getAppContext().getCurrentActivity(), msg, null, null, null, null, null);
    }

    /**
     * 设置所有价格相关字段数据
     * Qty、Itemtype、Itemno、Advprice、MixGroupDiscPrice字段需提前设置值
     * <p>
     * //     * @param datasBean
     * //     * @param isFuncmoney
     * //     * @param Money
     */
    public void setCalculatePrice(OrderDetail datasBean) {
        double money = datasBean.getUnit_price();
//        if (datasBean.getItemtype() == 1 && isFuncmoney == false && datasBean.getAdvprice() != 2) {
////            money = getMoney(datasBean.getItemno(), datasBean.getQty(), 0, new Date());
//        } else {
//            money = Money;
//            datasBean.manualMoney = money;
//            datasBean.isManualMoney = true;
//        }
        datasBean.setUnit_price(money);
        datasBean.setPrice(money * datasBean.getNumber());
    }

    public int getSize() {
        return orderFoodList != null ? orderFoodList.size() : 0;
    }

    public void close() {
        if (orderFoodList != null) {
            orderFoodList.clear();
        }
//        if (comboOrders != null) {
//            comboOrders.clear();
//        }
//        if (MixOldOrders != null) {
//            MixOldOrders.clear();
//        }
//        if (mixComboGroup_Discounts != null) {
//            mixComboGroup_Discounts.clear();
//        }
//
//        if (MixComboGroups != null) {
//            MixComboGroups.clear();
//        }
//        allowAddAutoDiscount = false;
//        MixComboGroups = null;
    }

    public void clear() {
        if (memberInfo != null) {
            memberInfo = null;
        }
        if (orderFoodList != null) {
            orderFoodList.clear();
        }
        if (newFoodList != null) {
            newFoodList.clear();
        }
        if (orderMoneyList != null) {
            orderMoneyList.clear();
        }
        if (billMoney != null) {
            billMoney.clear();
        }
        if (deleteOrders != null) {
            deleteOrders.clear();
        }
        addPoints = 0;
        oldPoints = 0;
        nowPoints = 0;
        integralQrcode = "";
        wholeAmount = 0.0;
        totalAmount = 0.0;
        orderBean = null;
        modifyOrder = false;
    }

    public boolean isOverMaxQty() {
        return overMaxQty;
    }

    public void setOverMaxQty(boolean overMaxQty) {
        this.overMaxQty = overMaxQty;
    }

    public int getLanguageindex() {
        return Languageindex;
    }

    public void setLanguageindex(int languageindex) {
        Languageindex = languageindex;
    }

    public boolean isEdit_Send() {
        return Edit_Send;
    }

    public void setEdit_Send(boolean edit_Send) {
        Edit_Send = edit_Send;
    }

    public int getSelpostion() {
        return selpostion;
    }

    public void setSelpostion(int selpostion) {
        this.selpostion = selpostion;
    }

    public int getSelstartpostion() {
        return selstartpostion;
    }

    public void setSelstartpostion(int selstartpostion) {
        this.selstartpostion = selstartpostion;
    }

    public int getSelendpostion() {
        return selendpostion;
    }

    public void setSelendpostion(int selendpostion) {
        this.selendpostion = selendpostion;
    }

    public int getSelmainstartpositon() {
        return selmainstartpositon;
    }

    public void setSelmainstartpositon(int selmainstartpositon) {
        this.selmainstartpositon = selmainstartpositon;
    }

    public int getSelmainendpostion() {
        return selmainendpostion;
    }

    public void setSelmainendpostion(int selmainendpostion) {
        this.selmainendpostion = selmainendpostion;
    }

    public int getSelect_Full_start_position() {
        return select_Full_start_position;
    }

    public void setSelect_Full_start_position(int select_Full_start_position) {
        this.select_Full_start_position = select_Full_start_position;
    }

    public int getSelect_Full_end_position() {
        return select_Full_end_position;
    }

    public void setSelect_Full_end_position(int select_Full_end_position) {
        this.select_Full_end_position = select_Full_end_position;
    }

    public static OrderDetails.DataBean getDataBean() {
        return dataBean;
    }

    public static void setDataBean(OrderDetails.DataBean dataBean) {
        MyOrderManage.dataBean = dataBean;
    }

    public int getSeqno() {
        return seqno;
    }

    public void setSeqno(int seqno) {
        this.seqno = seqno;
    }

    public int getSseq() {
        return sseq;
    }

    public void setSseq(int sseq) {
        this.sseq = sseq;
    }

    public int getMseq() {
        return mseq;
    }

    public void setMseq(int mseq) {
        this.mseq = mseq;
    }

    public float getAddPoints() {
        return addPoints;
    }

    public void setAddPoints(float addPoints) {
        this.addPoints = addPoints;
    }

    public float getOldPoints() {
        return oldPoints;
    }

    public void setOldPoints(float oldPoints) {
        this.oldPoints = oldPoints;
    }

    public float getNowPoints() {
        return nowPoints;
    }

    public void setNowPoints(float nowPoints) {
        this.nowPoints = nowPoints;
    }

    public String getIntegralQrcode() {
        return integralQrcode;
    }

    public void setIntegralQrcode(String integralQrcode) {
        this.integralQrcode = integralQrcode;
    }

    public List<OrderDetail> getOrderFoodList() {
        if (orderFoodList == null) {
            orderFoodList = new ArrayList<>();
        }
        return orderFoodList;
    }

    public void setOrderFoodList(List<OrderDetail> orderFoodList) {
        this.orderFoodList = orderFoodList;
    }

    public List<BillOrderMoney> getOrderMoneyList() {
        if (orderMoneyList == null) {
            orderMoneyList = new ArrayList<>();
        }
        return orderMoneyList;
    }

    public void setOrderMoneyList(List<BillOrderMoney> orderMoneyList) {
        this.orderMoneyList = orderMoneyList;
    }

    public double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getWholeAmount() {
        return wholeAmount;
    }

    public void setWholeAmount(double wholeAmount) {
        this.wholeAmount = wholeAmount;
    }

    public boolean isModifyOrder() {
        return modifyOrder;
    }

    public void setModifyOrder(boolean modifyOrder) {
        this.modifyOrder = modifyOrder;
    }

    public List<PayMethod> getBillMoney() {
        return billMoney;
    }

    public void setBillMoney(List<PayMethod> billMoney) {
        this.billMoney = billMoney;
    }

    public List<OrderDetail> getNewFoodList() {
        return newFoodList;
    }

    public void setNewFoodList(List<OrderDetail> newFoodList) {
        this.newFoodList = newFoodList;
    }
}
