package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.view.View;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Language;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.LanguageType;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainSideMenuBean;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/3/7.
 */
public class LanguageAdapter extends BaseQuickAdapter<LanguageType, BaseViewHolder> {

    public LanguageAdapter(@Nullable List<LanguageType> data) {
        super(R.layout.main_item_language, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, LanguageType item) {
        helper.setText(R.id.tv_language_name, item.getLanguageInfo());
        RadioButton rb_selected = helper.getView(R.id.rb_selected);
//        setOnItemClickListener(new com.chad.library.adapter.base.listener.OnItemClickListener() {
//            @Override
//            public void onItemClick(@NonNull BaseQuickAdapter<?, ?> adapter, @NonNull View view, int position) {
//                List<LanguageType> data = getData();
//                for (LanguageType item : data) {
//                    item.setSelected(false);
//                }
//                data.get(position).setSelected(true);
//            }
//        });
        rb_selected.setChecked(item.isSelected());
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(LanguageType item,int position,BaseQuickAdapter adapter);

    }
}
