package com.gingersoft.gsa.cloud.table.mvp.model.cart;

import com.gingersoft.gsa.cloud.base.common.bean.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.common.bean.DeleteOrderRequest;
import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.discount.CouponDiscountBean;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.CouponDiscount;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.MemberDiscount;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.MultyDiscount;
import com.gingersoft.gsa.cloud.table.mvp.model.discount.NomalDiscount;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 餐檯下單購物車
 */
@Data
public class ShoppingCart {

    private static ShoppingCart shoppingCart;

    private ShoppingCart() {
    }

    public static ShoppingCart getInstance() {
        if (shoppingCart == null) {
            shoppingCart = new ShoppingCart();
        }
        return shoppingCart;
    }


    private MultyDiscount multyDiscounts;

    /**
     * 食品列表
     */
    private List<OrderDetail> orderFoodList = new ArrayList<>();
    /**
     * 記錄刪除的食品以及原因
     */
    private List<DeleteOrderRequest> deleteOrders;
    /**
     * 整單折扣，服務費
     */
    protected List<BillOrderMoney> orderMoneyList = new ArrayList<>();


    public MultyDiscount addNomalDiscount(Discount discount) {
        multyDiscounts = new NomalDiscount(multyDiscounts, discount);
        return multyDiscounts;
    }

    public MultyDiscount addMemberDiscount(MemberInfo discount) {
        multyDiscounts = new MemberDiscount(multyDiscounts, discount);
        return multyDiscounts;
    }

    public MultyDiscount addCouponDiscount(CouponDiscountBean discount) {
        multyDiscounts = new CouponDiscount(multyDiscounts, discount);
        return multyDiscounts;
    }

    public static void main(String[] arg) {
        Discount discount = new Discount();
        discount.setType(1);
        discount.setRemark("9折");
        discount.setDiscount_value(10);

        MemberInfo memberDiscount = new MemberInfo();
        memberDiscount.setMemberName("斯八達");
        memberDiscount.setMemberDiscount(20);

        CouponDiscountBean couponDiscount = new CouponDiscountBean();
        couponDiscount.setCouponType((byte) 2);
        couponDiscount.setCouponTypeName1("立減8元");
        couponDiscount.setAmount(8);

        NomalDiscount nomalDiscountBean = (NomalDiscount) ShoppingCart.getInstance().addNomalDiscount(discount);
        MemberDiscount memberDiscountBean = (MemberDiscount) ShoppingCart.getInstance().addMemberDiscount(memberDiscount);
        CouponDiscount couponDiscountBean = (CouponDiscount) ShoppingCart.getInstance().addCouponDiscount(couponDiscount);

        MultyDiscount multyDiscount = ShoppingCart.getInstance().getMultyDiscounts();
        double money = multyDiscount.calculate(100);

        System.out.println("calculate : " + money);
        System.out.println("NomalDiscount discountMoney : " + nomalDiscountBean.getDiscountMoney());
        System.out.println("MemberDiscount discountMoney : " + memberDiscountBean.getDiscountMoney());
        System.out.println("CouponDiscount discountMoney : " + couponDiscountBean.getDiscountMoney());
    }


    /**
     * 具體支付類需要實現的方法
     */
    public void pay(double money) {

    }
}
