/*
 * Decompiled with CFR 0.152.
 */
package com.hyweb.n5.lib.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.os.IBinder;
import android.os.RemoteException;
import com.hyweb.n5.lib.exception.NoInitPrinterException;
import com.hyweb.n5.server.aidl.IOnPrintCallback;
import com.hyweb.n5.server.aidl.IPrinterService;
import java.util.List;

public class PrinterUtil {
    private static IPrinterService mPrinterService;
    private static ServiceConnection mServiceConnection;

    static {
        mServiceConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                mPrinterService = null;
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                mPrinterService = IPrinterService.Stub.asInterface(service);
            }
        };
    }

    private static void bindPrinterService(Context context) {
        Intent implicitIntent;
        Context localContext = context.getApplicationContext();
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent = new Intent("com.hyweb.n5.server.aidl.IPrinterService"), 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        localContext.bindService(explicitIntent, mServiceConnection, 1);
    }

    public static int initPrinter(Context context) throws NoInitPrinterException, RemoteException {
        PrinterUtil.bindPrinterService(context);
        if (mPrinterService == null) {
            throw new NoInitPrinterException();
        }
        return mPrinterService.initPrinter();
    }

    public static void registerCallback(IOnPrintCallback cb) throws RemoteException {
        mPrinterService.registerCallback(cb);
    }

    public static void unregisterCallback(IOnPrintCallback cb) throws RemoteException {
        mPrinterService.unregisterCallback(cb);
    }

    public static int getStatus() throws RemoteException {
        return mPrinterService.getStatus();
    }

    public static void appendImage(Bitmap bitmap, int align) throws RemoteException {
        mPrinterService.appendImage(bitmap, align);
    }

    public static void appendPrnStr(String text, int fontsize, int align, boolean isBoldFont) throws RemoteException {
        mPrinterService.appendPrnStr(text, fontsize, align, isBoldFont);
    }

    public static void appendPrnStr(String ltext, String rtext, int font, int ascfont, boolean isZoomX, boolean isZoomY) throws RemoteException {
        mPrinterService.appendPrnFormatedStr(ltext, rtext, ascfont, font, isZoomX, isZoomY);
    }

    public static void appendPrnBothStr(String leftText, String rightText, int fontsize, boolean isBoldFont) throws RemoteException {
        mPrinterService.appendPrnBothStr(leftText, rightText, fontsize, isBoldFont);
    }

    public static void appendBarcode(String content, int height, int margin, int scale, int barcodeFormat, int align) throws RemoteException {
        mPrinterService.appendBarcode(content, height, margin, scale, barcodeFormat, align);
    }

    public static void appendQRCode(String content, int height, int align, int version, int level) throws RemoteException {
        mPrinterService.appendQRCode(content, height, align, version, level);
    }

    public static void feedPaper(int value) throws RemoteException {
        mPrinterService.feedPaper(value);
    }

    public static void cutPaper() throws RemoteException {
        mPrinterService.cutPaper();
    }

    public static void startPrint(boolean rollPaperEnd, IOnPrintCallback cb) throws RemoteException {
        mPrinterService.startPrint(rollPaperEnd, cb);
    }

    public static void setLetterSpacing(int value) throws RemoteException {
        mPrinterService.setLetterSpacing(value);
    }

    public static void setGray(int grayLevel) throws RemoteException {
        mPrinterService.setGray(grayLevel);
    }

    public static void setTypeface(int typeface) throws RemoteException {
        mPrinterService.setTypeface(typeface);
    }
}

