package com.gingersoft.gsa.delivery_pick_mode.mvp.ui.adapter;

import android.content.Context;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.print.bean.PrjBean;
import com.gingersoft.gsa.delivery_pick_mode.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.math.BigDecimal;
import java.util.List;

public class PrjStateAdapter extends BaseQuickAdapter<PrjBean.DataBean.Bean, BaseViewHolder> {

    private Context context;
    private int indentation;

    public PrjStateAdapter(Context context, @Nullable List<PrjBean.DataBean.Bean> data) {
        super(R.layout.item_prj_state, data);
        this.context = context;
        addChildClickViewIds(R.id.tv_prj_record_print_operation);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, PrjBean.DataBean.Bean dataBean) {
        TextView state = baseViewHolder.getView(R.id.tv_prj_record_print_state);
        TextView foodName = baseViewHolder.getView(R.id.tv_prj_record_food_name);
        foodName.setText(dataBean.getProductName());

        if (dataBean.getPrinterType() == 3) {
            state.setText("已打印");
            state.setTextColor(ContextCompat.getColor(context, R.color.order_state4_color));
        } else if (dataBean.getPresence() == 0) {
            state.setText("未生成打印記錄");
            state.setTextColor(ContextCompat.getColor(context, R.color.red));
        } else if (dataBean.getPrinterDeviceId() == -1) {
            state.setText("未配置打印位置");
            state.setTextColor(ContextCompat.getColor(context, R.color.red));
        } else {
            state.setText("打印失敗");
            state.setTextColor(ContextCompat.getColor(context, R.color.red));
        }
        state.setSelected(true);
        if (baseViewHolder.getAdapterPosition() == 0) {
            //只第一次測量一下
            indentation = new BigDecimal(foodName.getPaint().measureText("哈")).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
        }
        if (dataBean.getParentId() != 0) {
            foodName.setPadding(indentation, foodName.getPaddingTop(), foodName.getPaddingRight(), foodName.getPaddingBottom());
        } else {
            foodName.setPadding(0, foodName.getPaddingTop(), foodName.getPaddingRight(), foodName.getPaddingBottom());
        }
    }
}
