package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.content.Context;

import com.chad.library.adapter.base.BaseProviderMultiAdapter;
import com.gingersoft.gsa.cloud.common.core.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SummaryBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.TimePeriodBean;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import static com.gingersoft.gsa.cloud.common.utils.time.TimeUtils.DATE_FORMAT_DATE;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.ADD_FOOD_ITEM;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.ADD_FOOD_ITEM_GROUP;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.ADD_FOOD_SET_MEAL;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.FOOD_PROPERTIES;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.NEW_FOOD_GROUP;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.NEW_FOOD_ITEM;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.NEW_FOOD_SET_MEAL;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.NEW_FOOD_SET_MEAL_GROUP;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.NEW_FOOD_TYPE;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.NEW_TIME_PERIOD;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.SELECT_EXCLUDE_LIST;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.SELECT_FOOD;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.SELECT_FOOD_ITEM_GROUP;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.SELECT_FOOD_SET_MEAL_GROUP;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.SELECT_LIST;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.BaseFoodMenuFragment.SELECT_PRINT;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodMenuFragment.SELECT_FOOD_GROUP;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodMenuFragment.SELECT_FOOD_TYPE;
import static com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodMenuFragment.SELECT_TIME_PERIOD;

/**
 * @author admin
 */
public class FoodMenuAdapter extends BaseProviderMultiAdapter<FoodMenuEditBean> {
    private static FoodMenuEditBean showClient;

    public static List<FoodMenuEditBean> getFoodMenuEditBean(int listType) {
        List<FoodMenuEditBean> foodMenuEditBeans;
        switch (listType) {
            case NEW_FOOD_GROUP:
                foodMenuEditBeans = getNewFoodGroupData();
                break;
            case FOOD_PROPERTIES:
                foodMenuEditBeans = getNewFoodProperties();
                break;
            case NEW_FOOD_TYPE:
                foodMenuEditBeans = getNewFoodType();
                break;
            case NEW_TIME_PERIOD:
                foodMenuEditBeans = getNewTimePeriod();
                break;
            case ADD_FOOD_ITEM:
                foodMenuEditBeans = getAddFoodItems();
                break;
            case ADD_FOOD_ITEM_GROUP:
                foodMenuEditBeans = getAddFoodItemsGroup();
                break;
            case NEW_FOOD_ITEM:
                foodMenuEditBeans = getNewFoodItem();
                break;
            case ADD_FOOD_SET_MEAL:
                foodMenuEditBeans = getAddFoodSetMeal();
                break;
            case NEW_FOOD_SET_MEAL_GROUP:
                foodMenuEditBeans = getNewFoodSetMealGroup();
                break;
            case NEW_FOOD_SET_MEAL:
                foodMenuEditBeans = getNewFoodSetMeal();
                break;
            default:
                foodMenuEditBeans = null;
                break;
        }
        return foodMenuEditBeans;
    }

    public static FoodMenuAdapter getFoodMenuAdapter(Context context, List<FoodMenuEditBean> foodMenuEditBeans) {
        return new FoodMenuAdapter(context, foodMenuEditBeans);
    }

    public FoodMenuAdapter(Context context, List<FoodMenuEditBean> foodMenuEditBeans) {
        super(foodMenuEditBeans);
        addItemProvider(new ThickLineProvider());
        addItemProvider(new InputItemProvider());
        addItemProvider(new SelectItemProvider(context));
        addItemProvider(new BooleanItemProvider());
        addItemProvider(new CheckBoxItemProvider(context));
        addItemProvider(new PicUploadPicProvider(context));
        addItemProvider(new RadioItemProvider(context));
    }

    @Override
    protected int getItemType(@NotNull List<? extends FoodMenuEditBean> list, int i) {
        return list.get(i).getItemType();
    }

    /**
     * 新增食品組
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewFoodGroupData() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品組名稱1", true, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品組名稱2", false, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品組名稱3", false, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "時段", false, "默認為全時段", SELECT_TIME_PERIOD));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "餐種", false, "請選擇餐種", SELECT_FOOD_TYPE));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "顯示狀態", false, true, true));

        List<FoodMenuEditBean.ShowClient> checkBoxList = new ArrayList<>();
        checkBoxList.add(new FoodMenuEditBean.ShowClient("H5", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("GSA", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("APP", false));
        showClient = new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "顯示端", false, true, checkBoxList);
        foodMenuEditBeans.add(showClient);
        return foodMenuEditBeans;
    }

    public void removeClient() {
        this.remove(showClient);
    }

    public void addClient() {
        this.addData(showClient);
    }

    /**
     * 新增食品的基本屬性
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewFoodProperties() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "食品組", true, "請選擇食品組", SELECT_FOOD_GROUP));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱1", true, "請輸入食品名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱2", false, "請輸入食品名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱3", false, "請輸入食品名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品金額", true, "請輸入食品金額"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品原價", true, "請輸入食品原價"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "打印位置", true, "請選擇打印位置"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "餐種", true, "請選擇餐種", SELECT_FOOD_TYPE));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "時段", false, "全時段", SELECT_TIME_PERIOD));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品描述", false, ""));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "啟用", false, true));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "折扣", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "服務費", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "打印至賬單", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "打印主項", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_UPLOAD_PIC, "圖片上傳", true));
        return foodMenuEditBeans;
    }

    /**
     * 新增餐種
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewFoodType() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "餐種名稱", true, "請選擇餐種名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "是否生效", false, true));
        return foodMenuEditBeans;
    }

    public SummaryBean getSummaryInfo() {
        List<FoodMenuEditBean> data = getData();
        SummaryBean summaryBean = data.get(0).getSummaryBean();
        if(summaryBean == null){
            summaryBean = new SummaryBean();
        }
        summaryBean.setRestaurantId(ResturantInfoManager.newInstance().getRestaurantId());
        summaryBean.setName(data.get(0).getShowValue());
        summaryBean.setValid(data.get(1).isShowState() ? 1 : 0);
        return summaryBean;
    }

    /**
     * 新增時段
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewTimePeriod() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "時段名稱1", true, "請輸入時段名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "時段名稱2", false, "請輸入時段名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "時段名稱3", false, "請輸入時段名稱"));

        Calendar calendar = Calendar.getInstance();

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "開始日期", false, "", DATE_FORMAT_DATE.format(calendar.getTime()), FoodMenuEditBean.SELECT_DATE));
        calendar.set(Calendar.YEAR, calendar.get(Calendar.YEAR) + 10);
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "結束日期", false, "", DATE_FORMAT_DATE.format(calendar.getTime()), FoodMenuEditBean.SELECT_DATE));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "開始時間", false, "", "00:00:00", FoodMenuEditBean.SELECT_TIME));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "結束時間", false, "", "23:59:59", FoodMenuEditBean.SELECT_TIME));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "週期", false));

        List<FoodMenuEditBean.ShowClient> checkBoxList = new ArrayList<>();
        checkBoxList.add(new FoodMenuEditBean.ShowClient("假期", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週一", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週二", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週三", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週四", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週五", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週六", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週日", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "", false, checkBoxList));
        return foodMenuEditBeans;
    }

    /**
     * @return 新增時段數據
     */
    public TimePeriodBean getTimePeriodInfo() {
        List<FoodMenuEditBean> data = getData();
        TimePeriodBean timePeriodBean = data.get(0).getTimePeriodBean();
        if (timePeriodBean == null) {
            timePeriodBean = new TimePeriodBean();
        }
        timePeriodBean.setId(data.get(0).getId());
        timePeriodBean.setPeriodName1(data.get(0).getShowValue());
        timePeriodBean.setPeriodName2(data.get(1).getShowValue());
        timePeriodBean.setPeriodName3(data.get(2).getShowValue());
        timePeriodBean.setBeginDate(data.get(3).getShowValue());
        timePeriodBean.setEndDate(data.get(4).getShowValue());
        timePeriodBean.setBeginTime(data.get(5).getShowValue());
        timePeriodBean.setEndTime(data.get(6).getShowValue());

        List<FoodMenuEditBean.ShowClient> checkBoxList = data.get(9).getCheckBoxList();
        timePeriodBean.setDay1(checkBoxList.get(1).isChecked() ? 1 : 0);
        timePeriodBean.setDay2(checkBoxList.get(2).isChecked() ? 1 : 0);
        timePeriodBean.setDay3(checkBoxList.get(3).isChecked() ? 1 : 0);
        timePeriodBean.setDay4(checkBoxList.get(4).isChecked() ? 1 : 0);
        timePeriodBean.setDay5(checkBoxList.get(5).isChecked() ? 1 : 0);
        timePeriodBean.setDay6(checkBoxList.get(6).isChecked() ? 1 : 0);
        timePeriodBean.setDay7(checkBoxList.get(7).isChecked() ? 1 : 0);
        timePeriodBean.setDayH(checkBoxList.get(0).isChecked() ? 1 : 0);
        return timePeriodBean;
    }

    /**
     * 加配細項
     *
     * @return
     */
    public static List<FoodMenuEditBean> getAddFoodItems() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱", false, "", false));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "細線組", false, "請選擇", SELECT_FOOD_ITEM_GROUP));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "最小數量", false, "請輸入最小數量"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "最大數量", false, "請輸入最大數量"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "優惠金額", false, "請輸入優惠金額"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "整組優惠金額", false, "請輸入整組優惠金額"));

        List<FoodMenuEditBean.ShowClient> showTypes = new ArrayList<>();
        showTypes.add(new FoodMenuEditBean.ShowClient("普通組別", false));
        showTypes.add(new FoodMenuEditBean.ShowClient("加配食品", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_RADIO, "展示類型", false, showTypes));

        List<FoodMenuEditBean.ShowClient> selectCount = new ArrayList<>();
        selectCount.add(new FoodMenuEditBean.ShowClient("選擇一次", false));
        selectCount.add(new FoodMenuEditBean.ShowClient("選擇多次", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_RADIO, "選擇次數", false, selectCount));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "默認選擇", false, "請選擇", SELECT_LIST));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "排除選項", false, "請選擇", SELECT_EXCLUDE_LIST));
        return foodMenuEditBeans;
    }

    /**
     * 加配套餐
     *
     * @return
     */
    public static List<FoodMenuEditBean> getAddFoodSetMeal() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱", false, "", false));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "套餐", false, "請選擇", SELECT_FOOD_SET_MEAL_GROUP));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "優惠金額", false, "請輸入優惠金額"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "整組優惠金額", false, "請輸入整組優惠金額"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "選擇數量", false, "請輸入"));

        List<FoodMenuEditBean.ShowClient> showTypes = new ArrayList<>();
        showTypes.add(new FoodMenuEditBean.ShowClient("普通組別", false));
        showTypes.add(new FoodMenuEditBean.ShowClient("加配食品", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_RADIO, "展示類型", false, showTypes));

        List<FoodMenuEditBean.ShowClient> selectCount = new ArrayList<>();
        selectCount.add(new FoodMenuEditBean.ShowClient("選擇一次", false));
        selectCount.add(new FoodMenuEditBean.ShowClient("選擇多次", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_RADIO, "選擇次數", false, selectCount));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "默認選擇", false, "請選擇", SELECT_LIST));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "排除選項", false, "請選擇", SELECT_EXCLUDE_LIST));
        return foodMenuEditBeans;
    }

    /**
     * 加配細項
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewFoodItem() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "細項組", true, "請選擇細項組", SELECT_FOOD_ITEM_GROUP));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項名稱1", true, "請輸入細項名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項名稱2", false, "請輸入細項名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項名稱3", false, "請輸入細項名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項金額", true, "請輸入細項金額"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項原價", true, "請輸入細項原價"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "打印位置", true, "請選擇打印位置", SELECT_PRINT));
        List<FoodMenuEditBean.ShowClient> selectCount = new ArrayList<>();
        selectCount.add(new FoodMenuEditBean.ShowClient("多選", false));
        selectCount.add(new FoodMenuEditBean.ShowClient("口味", false));
        selectCount.add(new FoodMenuEditBean.ShowClient("信息", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "顯示端", false, selectCount));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "細線啟用狀態", false, true));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "折扣", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "服務費", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "打印賬單上", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "打印主項", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_UPLOAD_PIC, "圖片上傳", true));
        return foodMenuEditBeans;
    }

    /**
     * 新增細項組
     */
    public static List<FoodMenuEditBean> getAddFoodItemsGroup() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項組名稱1", false, "請輸入細項組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項組名稱2", false, "請輸入細項組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "細項組名稱3", false, "請輸入細項組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "顯示圖片", false, false));
        List<FoodMenuEditBean.ShowClient> selectCount = new ArrayList<>();
        selectCount.add(new FoodMenuEditBean.ShowClient("顯示", true));
        selectCount.add(new FoodMenuEditBean.ShowClient("隱藏", false));
        selectCount.add(new FoodMenuEditBean.ShowClient("暫停", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "顯示狀態", false, selectCount));
        return foodMenuEditBeans;
    }

    /**
     * 新增套餐項
     */
    public static List<FoodMenuEditBean> getNewFoodSetMeal() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "套餐組名稱", false, "請選擇", SELECT_FOOD_SET_MEAL_GROUP));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "食品", false, "請選擇", SELECT_FOOD));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "可選擇數量", false, "請輸入"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "自定義金額", false, "請輸入"));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "顯示", false, true));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "分賬主項", false, false));
        return foodMenuEditBeans;
    }

    /**
     * 新增套餐組
     */
    public static List<FoodMenuEditBean> getNewFoodSetMealGroup() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "套餐名稱1", false, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "套餐名稱2", false, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "套餐名稱3", false, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "顯示圖片", false, false));
        List<FoodMenuEditBean.ShowClient> selectCount = new ArrayList<>();
        selectCount.add(new FoodMenuEditBean.ShowClient("顯示", true));
        selectCount.add(new FoodMenuEditBean.ShowClient("隱藏", false));
        selectCount.add(new FoodMenuEditBean.ShowClient("暫停", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "顯示狀態", false, selectCount));
        return foodMenuEditBeans;
    }


}
