package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Gravity;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.print.bean.PrintServingPaperContent;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.HtmlLable;
import com.joe.print.mvp.print.common.HtmlContract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.joe.print.mvp.print.common.HtmlContract.LABLE_COLUMN;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_DIV;

/**
 * 上菜紙打印  已改新版
 */
public class PrintServe extends PrinterRoot<PrintServingPaperContent> {

    private PrintServingPaperContent mPrintServingPaperContent;

    @Override
    protected void setPrintContent(PrintServingPaperContent printContent) {
        this.mPrintServingPaperContent = printContent;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, printerDeviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {

        if (mPrintServingPaperContent == null) {
            return new String[]{"<html><body></body></html>"};
        }
        List<OrderDetail> foodList = DoshokuOrder.getInstance().getShoppingCart().getOrderCommodityList();
        TableBean.DataBean tableBean = DoshokuOrder.getInstance().getOpenTableInfo();

        if (foodList.size() == 0 || tableBean == null) {
            return new String[]{"<html><body></body></html>"};
        }

        String stringBuilder = "<html><body>" +
//                getHtmlPrintHeadInfo() +
//                getHtmlPrintHeadOrderInfo(tableBean) +
//                generateHtmlFoodInfoTwoColumns(foodList) +
//                getWholeLine() +
//                getHtmlFooter() +
                getHtmlContent(deviceBean) +
                "</body></html>";

        int printCount = getPrintCount(mContext);
        String[] pritContent = new String[printCount];
        for (int i = 0; i < printCount; i++) {
            pritContent[i] = stringBuilder;
        }
        return pritContent;
    }

    private String getHtmlContent(PrinterDeviceBean deviceBean) {

        List<HtmlLable> htmlLables = new ArrayList<>();

        /**
         * 頭部
         */
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintServingPaperContent.getBrand(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "28")));
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintServingPaperContent.getResturantName(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "28")));
//        htmlLables.add(new HtmlLable(LABLE_DIV, HtmlContract.dividing_line));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, HtmlContract.dividing_line)}, 24));
        /**
         * 訂單
         */
        String orderNum = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(DoshokuOrder.getInstance().getOrderNo())) {
            orderNum = "單號：" + DoshokuOrder.getInstance().getOrderNo();
        }
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "餐檯：" + mPrintServingPaperContent.getTableName())}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "人數：" + mPrintServingPaperContent.getPerson())}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, orderNum)}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "日期：" + TimeUtils.parseTimeRepeat(mPrintServingPaperContent.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT))}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, HtmlContract.dividing_line)}, 24));
        /**
         * 食品
         */
        if (mPrintServingPaperContent.getFoodItemList() != null && mPrintServingPaperContent.getFoodItemList().size() > 0) {
            htmlLables.addAll(getBBPosFoodLineString(mPrintServingPaperContent.getFoodItemList(), deviceBean));
            htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, HtmlContract.dividing_line)}, 24));
        }

        /**
         * 底部
         */
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintServingPaperContent.getPoliteLanguage(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));

        htmlLables.add(new HtmlLable(LABLE_DIV, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));

        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));

    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }

    private Bitmap getBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        List<OrderDetail> foodList = DoshokuOrder.getInstance().getShoppingCart().getOrderCommodityList();
        if (foodList == null || foodList.size() <= 0) {
            return null;
        }
        TableBean.DataBean tableBean = DoshokuOrder.getInstance().getOpenTableInfo();

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));
        String orderNo = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(DoshokuOrder.getInstance().getOrderNo())) {
            orderNo = "單號：" + DoshokuOrder.getInstance().getOrderNo();
        }
        //訂單信息
        layout.addView(getDiningTableOrderInfo(mContext, "餐檯：" + tableBean.getTableName(), "人數：" + DoshokuOrder.getInstance().getOpenTableInfo().getPerson(), orderNo, "日期：" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT)));
        layout.addView(getLine(mContext));

        layout.addView(getDiningFoodList(mContext, foodList, printerDeviceBean, 0, false));
        layout.addView(getLine(mContext));
        layout.addView(getTextView(mContext, "Thank you!", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        layout.addView(getTextView(mContext, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT), Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        return viewToZoomBitmap(mContext, layout, printerDeviceBean);
    }

}
