package com.gingersoft.supply_chain.mvp.bean;

import com.gingersoft.gsa.cloud.common.core.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/17
 * Time: 11:36
 * Use:
 */
@Data
public class ConfirmOrderBean {
    private PurchaseOrder purchaseOrder;
    private List<PurchaseOrderDetails> purchaseOrderDetails;
    private double minimumAmount;//最低採購金額
    @Data
    public static class PurchaseOrder implements Serializable {
        private static final long serialVersionUID = -8777410033061311699L;
        private int id;
        private int supplierId;
        private String supplierName;
        private int brandId;
        private int restaurantId;
        private String sendingAddress;
        //默認第二天
        private long initialShippingTime;
        private double totalAmount;
        private int shipping;
        private double actualPayment;
        private String remarks;
    }

    public static PurchaseOrder conversionPurchaseOrder(PurchaseFoodBean cartFood) {
        PurchaseOrder purchaseOrder = new PurchaseOrder();
        purchaseOrder.setSupplierId(cartFood.getSupplierId());
        purchaseOrder.setSupplierName(cartFood.getSupplierName());
        purchaseOrder.setBrandId(ResturantInfoManager.newInstance().getBrandId());
        purchaseOrder.setRestaurantId(ResturantInfoManager.newInstance().getRestaurantId());
        purchaseOrder.setInitialShippingTime(TimeUtils.getNextDayLong(1));
        purchaseOrder.setTotalAmount(MoneyUtil.priceCalculation(cartFood.getUnitPrice(), cartFood.getFoodQuantity()));
        purchaseOrder.setActualPayment(MoneyUtil.sum(purchaseOrder.getTotalAmount(), purchaseOrder.getShipping()));
        return purchaseOrder;
    }

    @Data
    public static class PurchaseOrderDetails {
        private int purchaseFoodId;
        private int foodQuantity;
        private double foodPrice;
        private int orderId;
    }

    public static PurchaseOrderDetails conversionPurchaseOrderDetails(PurchaseFoodBean cartFood) {
        PurchaseOrderDetails purchaseOrderDetails = new PurchaseOrderDetails();
        purchaseOrderDetails.setPurchaseFoodId(cartFood.getId());
        purchaseOrderDetails.setFoodQuantity(cartFood.getFoodQuantity());
        purchaseOrderDetails.setFoodPrice(cartFood.getUnitPrice());
        return purchaseOrderDetails;
    }


}
