package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;
import android.os.Bundle;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.mvp.bean.BasicUnitBean;
import com.gingersoft.supply_chain.mvp.bean.DeputyUnitBean;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodUnitPageFragment;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.FoodUnitPageContract;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.ArrayList;
import java.util.List;

import static com.gingersoft.supply_chain.mvp.content.Constant.GET_INFO_ERROR;
import static com.gingersoft.supply_chain.mvp.content.Constant.GET_INFO_LOADING;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2020 16:05
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class FoodUnitPagePresenter extends BasePresenter<FoodUnitPageContract.Model, FoodUnitPageContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;
    /**
     * 副單位
     */
    private List<DeputyUnitBean> deputyUnitBeans;
    /**
     * 是修改還是新增
     * true：修改
     * false：新增
     */
    private boolean isUpdate = false;
    /**
     * 基本單位名稱
     */
    private String basicUnitName;

    @Inject
    public FoodUnitPagePresenter(FoodUnitPageContract.Model model, FoodUnitPageContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void initData(Bundle arguments) {
        if (arguments != null) {
            basicUnitName = arguments.getString(FoodUnitPageFragment.BASIC_UNIT_KEY);
            deputyUnitBeans = (List<DeputyUnitBean>) arguments.getSerializable(FoodUnitPageFragment.DEPUTY_UNIT_KEY);
            if (TextUtil.isNotEmptyOrNullOrUndefined(basicUnitName)) {
                isUpdate = true;
            } else {
                isUpdate = false;
            }
        }
    }

    public void getDeputyUnitList() {
        mModel.getDeputyUnitList(ResturantInfoManager.newInstance().getBrandId(), ResturantInfoManager.newInstance().getRestaurantId())
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(GET_INFO_LOADING))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess() && baseResult.getData() != null) {
                            List<BasicUnitBean> basicUnitBeans = GsonUtils.jsonToList(GsonUtils.GsonString(baseResult.getData()), BasicUnitBean.class);
                            BasicUnitBean basicUnitBean = new BasicUnitBean();
                            basicUnitBean.setContent("+新增");
                            basicUnitBeans.add(basicUnitBean);
                            mRootView.loadBasicUnitAdapter(basicUnitBeans);
                        } else if (TextUtil.isNotEmptyOrNullOrUndefined(baseResult.getErrMsg())) {
                            mRootView.showMessage(baseResult.getErrMsg());
                        } else {
                            mRootView.showMessage(GET_INFO_ERROR);
                        }
                    }
                });
    }

    public void addDeputyUnit() {
        if (deputyUnitBeans.size() > 0) {
            DeputyUnitBean basicUnitBean = deputyUnitBeans.get(deputyUnitBeans.size() - 1);
            if (TextUtil.isEmptyOrNullOrUndefined(basicUnitBean.getDeputyUnit())) {
                mRootView.showMessage("請輸入副單位");
                mRootView.loadDeputyUnitAdapter(deputyUnitBeans);
                return;
            }
        }
        DeputyUnitBean unitBean = new DeputyUnitBean();
        deputyUnitBeans.add(unitBean);
        mRootView.loadDeputyUnitAdapter(deputyUnitBeans);
    }

    public void loadDeputyUnit(List<DeputyUnitBean> unitBeans) {
        if (unitBeans == null) {
            deputyUnitBeans = new ArrayList<>();
        } else {
            deputyUnitBeans = unitBeans;
        }
        mRootView.loadDeputyUnitAdapter(deputyUnitBeans);
    }
}
