package com.gingersoft.supply_chain.mvp.ui.fragment.food;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemChildClickListener;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerFoodUnitPageComponent;
import com.gingersoft.supply_chain.mvp.bean.BasicUnitBean;
import com.gingersoft.supply_chain.mvp.bean.DeputyUnitBean;
import com.gingersoft.supply_chain.mvp.contract.FoodUnitPageContract;
import com.gingersoft.supply_chain.mvp.presenter.FoodUnitPagePresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.BasicUnitAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.DeputyUnitAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.io.Serializable;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;


/**
 * ================================================
 * Description: 最新版食品單位填寫頁面
 */
public class FoodUnitPageFragment extends BaseSupplyChainFragment<FoodUnitPagePresenter> implements FoodUnitPageContract.View {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar topBar;
    @BindView(R2.id.ed_basic_unit)
    EditText edBasicUnit;
    @BindView(R2.id.rv_deputy_unit_list)
    RecyclerView rvDeputyUnitList;
    @BindView(R2.id.rv_basic_unit_list)
    RecyclerView rvBasicUnitList;
    @BindView(R2.id.tv_food_unit_complete)
    QMUIAlphaTextView tvFoodUnitComplete;

    private DeputyUnitAdapter deputyUnitAdapter;

    public final static String BASIC_UNIT_KEY = "basicUnitKey";
    public final static String DEPUTY_UNIT_KEY = "deputyUnitKey";

    /**
     * @param basicUnit       基本單位
     * @param deputyUnitBeans 副單位集合
     * @return
     */
    public static FoodUnitPageFragment newInstance(String basicUnit, List<DeputyUnitBean> deputyUnitBeans) {
        FoodUnitPageFragment fragment = new FoodUnitPageFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(DEPUTY_UNIT_KEY, (Serializable) deputyUnitBeans);
        bundle.putString(BASIC_UNIT_KEY, basicUnit);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerFoodUnitPageComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_food_unit_page, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mPresenter.initData(getArguments());
//        if(arguments != null){
//            arguments.getSerializable(DEPUTY_UNIT_KEY);
//        }
//        initTopBar(topBar, "填寫商品單位");
//        mPresenter.getDeputyUnitList();
//        mPresenter.loadDeputyUnit(null);
    }

    @OnClick({R2.id.tv_add_deputy})
    public void onClick(View view) {
        int viewId = view.getId();
        if (viewId == R.id.tv_add_deputy) {
            //添加副單位
            mPresenter.addDeputyUnit();
        }
    }

    @Override
    public void loadBasicUnitAdapter(List<BasicUnitBean> basicUnitBeans) {
        BasicUnitAdapter basicUnitAdapter = new BasicUnitAdapter(basicUnitBeans);
        rvBasicUnitList.setLayoutManager(new GridLayoutManager(mContext, 5));
        rvBasicUnitList.setAdapter(basicUnitAdapter);
        basicUnitAdapter.setOnItemClickListener((adapter, view, position) -> {
            //先獲取當前焦點在哪個輸入框上，然後再填充內容
            FragmentActivity activity = getActivity();
            if (activity != null) {
                Window window = activity.getWindow();
                if (window != null) {
                    View decorView = window.getDecorView();
                    View focusView = decorView.findFocus();
                    if (focusView instanceof EditText) {
                        EditText editText = (EditText) focusView;
                        editText.setText(editText.getText() + basicUnitAdapter.getData().get(position).getContent());
                    }
                }
            }
        });
    }

    @Override
    public void loadDeputyUnitAdapter(List<DeputyUnitBean> deputyUnitBeans) {
        if (deputyUnitAdapter == null) {
            deputyUnitAdapter = new DeputyUnitAdapter(deputyUnitBeans);
            rvDeputyUnitList.setAdapter(deputyUnitAdapter);
            deputyUnitAdapter.setOnItemChildClickListener((adapter, view, position) -> {
                if (view.getId() == R.id.iv_deputy_unit_delete) {
                    //刪除副單位
                    deputyUnitAdapter.removeAt(position);
                }
            });
        } else {
            deputyUnitAdapter.setList(deputyUnitBeans);
        }
    }
}
