package com.gingersoft.gsa.cloud.pay.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.pay.pos.PosAction;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2020-12-30 16:11
 * @更新時間: 2020-12-30 16:11
 * @描述:
 */
@Data
public class PosActionStatusExceptionParam implements Parcelable {

    private String txnId;
    private PosAction posAction;
    private long orderNum;
    private double amount;
    private String payMethodName;

    public PosActionStatusExceptionParam() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.txnId);
        dest.writeInt(this.posAction == null ? -1 : this.posAction.ordinal());
        dest.writeLong(this.orderNum);
        dest.writeDouble(this.amount);
        dest.writeString(this.payMethodName);
    }

    protected PosActionStatusExceptionParam(Parcel in) {
        this.txnId = in.readString();
        int tmpPosAction = in.readInt();
        this.posAction = tmpPosAction == -1 ? null : PosAction.values()[tmpPosAction];
        this.orderNum = in.readLong();
        this.amount = in.readDouble();
        this.payMethodName = in.readString();
    }

    public static final Creator<PosActionStatusExceptionParam> CREATOR = new Creator<PosActionStatusExceptionParam>() {
        @Override
        public PosActionStatusExceptionParam createFromParcel(Parcel source) {
            return new PosActionStatusExceptionParam(source);
        }

        @Override
        public PosActionStatusExceptionParam[] newArray(int size) {
            return new PosActionStatusExceptionParam[size];
        }
    };
}
