package com.joe.print.mvp.print;

import com.gingersoft.gsa.cloud.print.PrintDataMaker;
import com.gingersoft.gsa.cloud.print.PrinterWriter;
import com.gingersoft.gsa.cloud.print.PrinterWriterExecutor;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 * ip打印類
 */
public class OpenCashBoxMaker implements PrintDataMaker {

    private String ip;
    private int port;

    public OpenCashBoxMaker(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    @Override
    public List<byte[]> getPrintData() {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            PrinterWriter printer;
            printer = new PrinterWriterExecutor(255, 0);
            printer.openCashBox();
            data.add(printer.getDataAndClose());
            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    @Override
    public String getPrjIds() {
        return null;
    }

    @Override
    public String getIp() {
        return ip;
    }

    @Override
    public int getPort() {
        return port;
    }
}
