package com.gingersoft.gsa.cloud.table.mvp.presenter;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.FineItemOneselfContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.SoldoutCtrlActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ComboAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ModifierAdapter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import static com.gingersoft.gsa.cloud.table.mvp.ui.activity.SoldoutCtrlActivity.FOOD_TYPE;
import static com.gingersoft.gsa.cloud.table.mvp.ui.activity.SoldoutCtrlActivity.MODIFIER_TYPE;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/19/2020 22:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class FineItemOneselfPresenter extends BasePresenter<FineItemOneselfContract.Model, FineItemOneselfContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private ComboAdapter mComboAdapter;
    private ModifierAdapter mModifierAdapter;
    //套餐细项数据
    private List<ComboItem> mFoodComboList = new ArrayList<>();
    private List<Modifier> mModifierList = new ArrayList<>();

    //所有沽清数据
    private List<SoldoutCtrFood> mCurrentSoldoutFoodList_Full = null;

    private SoldoutCtrlActivity IActivity;

    @Inject
    public FineItemOneselfPresenter(FineItemOneselfContract.Model model, FineItemOneselfContract.View rootView) {
        super(model, rootView);
        this.IActivity = (SoldoutCtrlActivity) rootView.getCurrentActivity();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void initAdapter() {
        if (mComboAdapter == null) {
            mComboAdapter = new ComboAdapter(IActivity, mFoodComboList);
            mRootView.setComboAdapter(mComboAdapter);
        }
        if (mModifierAdapter == null) {
            mModifierAdapter = new ModifierAdapter(IActivity, mModifierList);
            mRootView.setModifierAdapter(mModifierAdapter);
        }
    }

    public void initItemListener(Context context) {
        mComboAdapter.setOnItemClickListener(new ComboAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(ComboItem datasBean, int position) {
                if (!foodStopOpeart(datasBean)) {
                    IActivity.showSoldoutNumberDialog(datasBean.getId(), null);
                }
            }
        });
        mModifierAdapter.setOnItemClickListener(new ModifierAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(Modifier datasBean, int position) {
                if (!modifierStopOpeart(datasBean)) {
                    IActivity.showSoldoutNumberDialog(null, datasBean.getMid());
                }
            }
        });
    }

    public void loadComboData(long fid) {

        if (mModifierList.size() > 0) {
            mModifierList.clear();
        }

        List<Modifier> modifierList = mModel.queryDB_ModifierList(fid, ModifierDaoUtils.modifierMode_All);
        mModifierList.addAll(modifierList);
    }


    public boolean foodStopOpeart(ComboItem datasBean) {
        boolean isStopOpeart = false;
        if (mCurrentSoldoutFoodList_Full != null) {
            for (SoldoutCtrFood csf : mCurrentSoldoutFoodList_Full) {
                if (csf.getFoodId() != null && datasBean.getId() != null &&
                        csf.getFoodId().equals(datasBean.getId()) && csf.getType() == FOOD_TYPE) {
                    if (datasBean.getInvisible() == 2 || !TextUtils.isEmpty(csf.getQtyName())) {
                        isStopOpeart = true;
                        if (datasBean.getInvisible() == 2) {
                            //恢復暫停數量
                            String msg = LanguageUtils.get_language_system(IActivity, "whether.recover", "是否恢復[") + datasBean.getName() + "]";
                            Class[] parameterTypes = {Long.class, int.class, int.class};
                            Object[] parameters = {datasBean.getId(), 2, 0};
                            CommonTipDialog.showDoubtDialog(IActivity, msg, SoldoutCtrlPresenter.class, IActivity.getSoldoutCtrlPresenter(), "updateInvisible", parameterTypes, parameters);
                        } else {
                            //暂停或者售罄直接提示恢复
                            String msg = LanguageUtils.get_language_system(IActivity, "whether.recover", "是否恢復[") + datasBean.getName() + "]";
                            Class[] parameterTypes = {long.class};
                            Object[] parameters = {csf.getId()};
                            CommonTipDialog.showDoubtDialog(IActivity, msg, SoldoutCtrlPresenter.class, IActivity.getSoldoutCtrlPresenter(), "restoreSoldoutCtrl", parameterTypes, parameters);
                        }
                        break;
                    }
                }
            }
        }
        return isStopOpeart;
    }

    private boolean modifierStopOpeart(Modifier datasBean) {
        boolean isStopOpeart = false;
        if (mCurrentSoldoutFoodList_Full != null) {
            for (SoldoutCtrFood csf : mCurrentSoldoutFoodList_Full) {
                if (csf.getModifierId() != null) {
                    if (csf.getModifierId() == datasBean.getMid() && csf.getType() == MODIFIER_TYPE) {
                        if (datasBean.getInvisible() == 2 || !TextUtils.isEmpty(csf.getQtyName())) {
                            isStopOpeart = true;
                            if (datasBean.getInvisible() == 2) {
                                //恢復暫停數量
                                String msg = LanguageUtils.get_language_system(IActivity, "whether.recover", "是否恢復[") + datasBean.getModifierName() + "]";
                                Class[] parameterTypes = {Long.class, int.class, int.class};
                                Object[] parameters = {datasBean.getMid(), 3, 0};
                                CommonTipDialog.showDoubtDialog(IActivity, msg, SoldoutCtrlPresenter.class, IActivity.getSoldoutCtrlPresenter(), "updateInvisible", parameterTypes, parameters);
                            } else {
                                String msg = LanguageUtils.get_language_system(IActivity, "whether.recover", "是否恢復[") + datasBean.getModifierName() + "]";
                                Class[] parameterTypes = {long.class};
                                Object[] parameters = {csf.getId()};
                                CommonTipDialog.showDoubtDialog(IActivity, msg, SoldoutCtrlPresenter.class, IActivity.getSoldoutCtrlPresenter(), "restoreSoldoutCtrl", parameterTypes, parameters);
                            }
                            break;
                        }
                    }
                }
            }
        }
        return isStopOpeart;
    }

    /**
     * 設置細項組獲細項沽清數據
     *
     * @param soldoutCtrList
     */
    public void setSoldoutFoodList_Full(List<SoldoutCtrFood> soldoutCtrList) {
        this.mCurrentSoldoutFoodList_Full = soldoutCtrList;
    }

    /**
     * 更新細項組沽清數據
     */
    public void updateSoldoutFoodList_Full() {
        for (int i = mCurrentSoldoutFoodList_Full.size() - 1; i >= 0; i--) {
            if (mCurrentSoldoutFoodList_Full.get(i).getType() == MODIFIER_TYPE && mCurrentSoldoutFoodList_Full.get(i).isStop()) {
                mCurrentSoldoutFoodList_Full.remove(i);
            }
        }

        cleaSoldoutCtrData();
        addStopSoldoutCtrItem(mCurrentSoldoutFoodList_Full);
        setSoldoutCtrItem(mCurrentSoldoutFoodList_Full);

//        mComboAdapter.notifyDataSetChanged();
        mModifierAdapter.notifyDataSetChanged();
    }

    private void setSoldoutCtrItem(List<SoldoutCtrFood> soldoutCtrList) {
        for (SoldoutCtrFood scc : soldoutCtrList) {
            for (Modifier modifier : mModifierList) {
                if (scc.getType() == MODIFIER_TYPE && scc.getModifierId() != null && modifier.getMid() == scc.getModifierId()) {
                    String qtyName;
                    if (modifier.getInvisible() == 2) {
                        qtyName = "暫停";
                        scc.setStop(true);
                        modifier.setMaxNumber(qtyName);
                        modifier.setCurrentMaxNumber(qtyName);
                    } else {
                        qtyName = scc.getQtyName();
                        scc.setStop(false);
                        modifier.setMaxNumber(qtyName);
                        modifier.setCurrentMaxNumber(qtyName);
                    }
                }
            }
        }
    }

    private void addStopSoldoutCtrItem(List<SoldoutCtrFood> soldoutCtrFoods) {
        for (Modifier modifier : mModifierList) {
            if (modifier.getInvisible() == 2) {
                SoldoutCtrFood soldoutCtrFood = new SoldoutCtrFood();
                soldoutCtrFood.setType((byte) MODIFIER_TYPE);
                soldoutCtrFood.setStop(true);
                soldoutCtrFood.setFoodName(modifier.getModifierName());
                soldoutCtrFood.setFoodName1(modifier.getModifierName1());
                soldoutCtrFood.setFoodName2(modifier.getModifierName2());
                soldoutCtrFood.setModifierId(modifier.getMid());
                if (!isContainsModifier(soldoutCtrFoods, modifier)) {
                    soldoutCtrFoods.add(soldoutCtrFood);
                }
            }
        }
    }

    private boolean isContainsModifier(List<SoldoutCtrFood> soldoutCtrFoods, Modifier modifier) {
        for (SoldoutCtrFood soldoutCtrFood : soldoutCtrFoods) {
            if (soldoutCtrFood.getType() == MODIFIER_TYPE && soldoutCtrFood.getModifierId() == modifier.getMid()) {
                return true;
            }
        }
        return false;
    }

    private void cleaSoldoutCtrData() {
        for (Modifier modifier : mModifierList) {
            modifier.setMaxNumber("");
            modifier.setCurrentMaxNumber("");
        }
        for (ComboItem comboItem : mFoodComboList) {
            comboItem.setMaxNumber("");
            comboItem.setCurrentMaxNumber("");
        }
    }


}
