package com.gingersoft.gsa.cloud.table.mvp.contract;

import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.discount.MemberCoupon;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.LoadSir;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.Single;
import retrofit2.http.Query;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/02/2021 17:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface CouponContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

        void returnMemberCouponList(List<MemberCoupon> memberCoupons);

        void showLoadSirSuccess();

        void showLoadSirCall(Class<? extends Callback> call);

        LoadService getLoadService();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        Single<List<MemberCoupon>> getMemberWalletList(int brandId, long memberId, long limitType, long pageIndex, long pageSize);

    }
}
