package com.gingersoft.gsa.cloud.common.config.globalconfig.applyOptions;

import android.content.Context;

import com.jess.arms.di.module.ClientModule;
import com.jess.arms.utils.DataHelper;

import java.io.File;

import io.rx_cache2.internal.RxCache;
import io.victoralbertos.jolyglot.GsonSpeaker;

public class MyRxCacheConfiguration implements ClientModule.RxCacheConfiguration {

    @Override
    public RxCache configRxCache(Context context, RxCache.Builder builder) {
//        builder.useExpiredDataIfLoaderNotAvailable(true);

        // 想自定义 RxCache 的缓存文件夹或者解析方式, 如改成 fastjson, 请 return rxCacheBuilder.persistence(cacheDirectory, new FastJsonSpeaker());
//        return null;
        // 当数据无法加载时，使用过期数据
        return builder.useExpiredDataIfLoaderNotAvailable(true)
                .persistence(provideRxCacheDirectory(context.getFilesDir()), new GsonSpeaker());
    }

    private File provideRxCacheDirectory(File cacheDir) {
        File cacheDirectory = new File(cacheDir, "RxCache");
        return DataHelper.makeDirs(cacheDirectory);
    }
}
