package com.gingersoft.gsa.cloud.common.utils.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;

/**
 * ImageUtils
 * 图片处理功能,主要功能是进行黑白化
 *
 * @author cq
 * @create by chen in 2016年8月19日11:43:59
 * @modify,
 * @modifytime
 */
public class ImageUtils {
    /**
     * 对图片进行压缩（去除透明度）
     *
     * @param
     */
    private static int errorcode;

    public static Bitmap compressPic(Bitmap bitmap, int newWidth, int newHeight) {
        // 获取这个图片的宽和高
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        // 指定调整后的宽度和高度
        // int newWidth = 240;
        //  int newHeight = 240;
        if (newWidth <= 0) {
            newWidth = 240;
            //setStatus(PrintErrorCode.IMAGE_WIDTH_ERROR);
        }
        if (newHeight <= 0) {
            newHeight = 240;
            //setStatus(PrintErrorCode.IMAGE_HEIGHT_ERROR);
        }
        Bitmap targetBmp = Bitmap.createBitmap(newWidth, newHeight, Bitmap.Config.ARGB_8888);
        Canvas targetCanvas = new Canvas(targetBmp);
        targetCanvas.drawColor(0xffffffff);
        targetCanvas.drawBitmap(bitmap, new Rect(0, 0, width, height), new Rect(0, 0, newWidth, newHeight), null);
        return targetBmp;
    }

    /**
     * 灰度图片黑白化，黑色是1，白色是0
     *
     * @param x   横坐标
     * @param y   纵坐标
     * @param bit 位图
     * @return
     */
    public static byte px2Byte(int x, int y, Bitmap bit) {
        if (x < bit.getWidth() && y < bit.getHeight()) {
            byte b;
            int pixel = bit.getPixel(x, y);
            int red = (pixel & 0x00ff0000) >> 16; // 取高两位
            int green = (pixel & 0x0000ff00) >> 8; // 取中两位
            int blue = pixel & 0x000000ff; // 取低两位
            int gray = RGB2Gray(red, green, blue);
            if (gray < 128) {
                b = 1;
            } else {
                b = 0;
            }
            return b;
        }
        return 0;
    }

    /**
     * 图片灰度的转化
     */
    private static int RGB2Gray(int r, int g, int b) {
        int gray = (int) (0.29900 * r + 0.58700 * g + 0.11400 * b);  //灰度转化公式
        return gray;
    }

    public int getStatus() {
        return errorcode;
    }

    private void setStatus(int errorcode) {
        this.errorcode = errorcode;
    }

    /**
     * 根據打印紙的寬度縮放圖片
     *
     * @param oldbmp
     * @param w
     * @param h
     * @return
     */
    public static Bitmap zoomDrawable(Bitmap oldbmp, int w, int h) {
        int width = oldbmp.getWidth();
        int height = oldbmp.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = ((float) w / width);
        float scaleHeight = ((float) h / height);
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap(oldbmp, 0, 0, width, height,
                matrix, true);
    }

    public static Bitmap zoomDrawable(Bitmap oldbmp, int w) {
        int width = oldbmp.getWidth();
        int height = oldbmp.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = ((float) w / width);
//        float scaleWidth = ((float) w / (width / 2f));//0.37
//        float scaleHeight = scaleWidth / 2;
        matrix.postScale(scaleWidth, scaleWidth);
        return Bitmap.createBitmap(oldbmp, 0, 0, width, height,
                matrix, true);
    }

    /**
     * 針式打印機用，因為是高密度模式，打印出來寬度會少一半，所以需要除以2
     *
     * @param oldbmp 圖片
     * @param w      打印紙寬度
     * @return 縮放後的圖片
     */
    public static Bitmap dotMatrixZoomDrawable(Bitmap oldbmp, int w) {
        int width = oldbmp.getWidth();
        int height = oldbmp.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = ((float) w / (width / 2f));
        float scaleHeight = scaleWidth / 2;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap(oldbmp, 0, 0, width, height,
                matrix, true);
    }

    public static Bitmap zoomDrawable(Bitmap oldbmp, int w, double heightMultiple) {
        int width = oldbmp.getWidth();
        int height = oldbmp.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = ((float) w / width);
        float scaleHeight = (float) (scaleWidth / heightMultiple);
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap(oldbmp, 0, 0, width, height,
                matrix, true);
    }


    /**
     * 缩放图片
     *
     * @param image    图片
     * @param maxWidth 最大宽
     * @return 缩放后的图片
     */
    public static Bitmap scalingBitmap(Bitmap image, int maxWidth) {
        if (image == null || image.getWidth() <= 0 || image.getHeight() <= 0)
            return null;
        try {
            final int width = image.getWidth();
            final int height = image.getHeight();
            // 精确缩放
            float scale = 1;
            if (maxWidth <= 0 || width <= maxWidth) {
                scale = maxWidth / (float) width;
            }
            Matrix matrix = new Matrix();
            matrix.postScale(scale, scale);
            return Bitmap.createBitmap(image, 0, 0, width, height, matrix, true);
        } catch (OutOfMemoryError e) {
            return null;
        }
    }
}
