package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.base.adapter.print.BillAdapter;
import com.gingersoft.gsa.cloud.base.adapter.print.BillTypeAdapter;
import com.gingersoft.gsa.cloud.base.adapter.print.FoodAdapter;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.joe.print.R;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 結賬單
 */
public class PrintBill extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getServeBitmap(mContext));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    /**
     * 獲取"結賬單"圖片
     *
     * @param context
     * @return
     */
    private Bitmap getServeBitmap(Context context) {
        List<OrderDetail> foodList = MyOrderManage.getInstance().getOrderFoodList();
        TableBean.DataBean tableBean = OpenTableManage.getDefault().getTableBean();
        if (foodList == null || foodList.size() <= 0 || tableBean == null) {
            return null;
        }
        View view = LinearLayout.inflate(context, R.layout.print_layout_print_bill, null);
        TextView brandName = view.findViewById(R.id.tv_brand_name);
        TextView restaurantName = view.findViewById(R.id.tv_restaurant_name);
        TextView topOrderNum = view.findViewById(R.id.tv_print_bill_order_num);//頂部的訂單號
        TextView tableNum = view.findViewById(R.id.tv_dining_table_number);
        TextView people = view.findViewById(R.id.tv_people);
        TextView orderNum = view.findViewById(R.id.tv_order_num);
        TextView orderData = view.findViewById(R.id.tv_date);
        RecyclerView rvFood = view.findViewById(R.id.rv_food);
        RecyclerView rvBillAmount = view.findViewById(R.id.rv_bill_amount);
        TextView mTvTotalAmount = view.findViewById(R.id.tv_total_amount);
        TextView checkOutTime = view.findViewById(R.id.tv_checkout_time);
        TextView line_food_info = view.findViewById(R.id.line_food_info);
        RecyclerView rvPayType = view.findViewById(R.id.rv_print_pay_type);//顯示支付方式


        brandName.setText(GsaCloudApplication.getBrandName(context));
        restaurantName.setText(GsaCloudApplication.getRestaurantName(context));

        tableNum.setText(tableBean.getTableName());
        people.setText(OpenTableManage.getDefault().getPeopleNumber() + "");

        orderData.setText(TimeUtils.parseTimeRepeat(tableBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT));
        checkOutTime.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT));

        FoodAdapter foodAdapter = new FoodAdapter(foodList);
        rvFood.setLayoutManager(new LinearLayoutManager(context));
        rvFood.setAdapter(foodAdapter);

        List<BillingBean> billingBeans = new ArrayList<>();
        if (MyOrderManage.getInstance().getOrderMoneyList().size() > 0) {
            for (BillOrderMoney item : MyOrderManage.getInstance().getOrderMoneyList()) {
                billingBeans.add(new BillingBean(item.getTitle(), item.getMoney()));
            }
        }

        if (billingBeans.size() <= 0) {
            line_food_info.setVisibility(View.GONE);
        } else {
            BillAdapter billAdapter = new BillAdapter(billingBeans);
            rvBillAmount.setLayoutManager(new LinearLayoutManager(context));
            rvBillAmount.setAdapter(billAdapter);
        }
        if (OpenTableManage.getDefault().getTableBean() != null) {
            tableNum.setText(OpenTableManage.getDefault().getTableBean().getTableName());
            people.setText(OpenTableManage.getDefault().getPeopleNumber() + "");
        }

        if (MyOrderManage.getInstance().getOrderId() != -1) {
            orderNum.setText(MyOrderManage.getInstance().getOrderId() + "");
        }

        BigDecimal totalAmount = new BigDecimal(0);
        for (OrderDetail OrderDetail : MyOrderManage.getInstance().getOrderFoodList()) {
            totalAmount = MoneyUtil.sum(totalAmount, OrderDetail.getPrice());
        }
        //總金額
        mTvTotalAmount.setText(totalAmount + "");

        List<PayMethod> payBillMoneys = MyOrderManage.getInstance().getBillMoney();
        rvPayType.setLayoutManager(new LinearLayoutManager(context));
        rvPayType.setAdapter(new BillTypeAdapter(payBillMoneys));
        //加载条形码
//        ImageView ivBarCode = view.findViewById(R.id.iv_bar_code);
//        ivBarCode.setImageBitmap(BitmapUtil.generateBitmap("12312112131", 2, 450, 150));
        return viewToBitmap(context, view);
    }
}
