package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;
import com.gingersoft.gsa.cloud.database.utils.ExpandInfoDaoUtils;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.PrintBillBean;
import com.joe.print.mvp.ui.adapter.BillItemAdapter;
import com.joe.print.mvp.ui.adapter.OtherOrderAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 打印外賣接單結賬單
 */
public class PrintOtherOrderClosing extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext) {
        OrderDetails.DataBean dataBean = MyOrderManage.getDataBean();
        if (dataBean != null) {
            Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
            List<Bitmap> bitmaps = new ArrayList<>();
            bitmaps.add(initPrintView(mContext, dataBean));
            bitmapMaps.put("", bitmaps);
            return bitmapMaps;
        }
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        ExpandInfoDaoUtils expandInfoDaoUtils = new ExpandInfoDaoUtils(context);
        List<ExpandInfo> expandInfos = expandInfoDaoUtils.queryAllExpandInfo();
        int printCount = 1;
        if (expandInfos != null) {
            for (ExpandInfo expandInfo : expandInfos) {
                if (expandInfo.getSettingName().equals(ExpandConstant.DeliveryPrintCount)) {
                    printCount = expandInfo.getValueInt();
                }
            }
        }
        return printCount;
    }

    private Bitmap initPrintView(Context context, OrderDetails.DataBean data) {
        View view = LayoutInflater.from(context).inflate(R.layout.print_confirm_order_view, null, false);
        TextView tvNowPoint = view.findViewById(R.id.tv_nowPoints);
        TextView tvAddPoints = view.findViewById(R.id.tv_addPoints);
        TextView tvOldPoints = view.findViewById(R.id.tv_oldPoints);
        //品牌名
        setText(view, R.id.tv_brand_name, GsaCloudApplication.getBrandName(context));
        //餐廳名
        setText(view, R.id.tv_restaurant_name, GsaCloudApplication.getRestaurantName(context));
        // 訂單類型
        setText(view, R.id.tv_order_type, data.getOrder_type() == 2 ? "外送" : "自取");
        // 訂單號
        setText(view, R.id.tv_order_number, "單號：" + data.getORDER_NO());
        if (data.getTakeFoodCode() != null && !data.getTakeFoodCode().equals("0")) {
            setText(view, R.id.tv_order_take_food_code, "取餐碼：#" + data.getTakeFoodCode());
        } else {
            view.findViewById(R.id.tv_order_take_food_code).setVisibility(View.GONE);
        }
        //訂單創建時間
        setText(view, R.id.tv_order_create, context.getString(R.string.create_order_time) + TimeUtils.parseTimeRepeat(data.getCREATE_TIME(), TimeUtils.DEFAULT_DATE_FORMAT));
        String amountUnit = context.getString(R.string.amount_unit);

        RecyclerView rvBill = view.findViewById(R.id.rv_bill);
        List<PrintBillBean> billData = new ArrayList<>();
        billData.add(getBillBean("合計：", amountUnit + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE())));
        if (data.getLunchbox() != 0) {
            billData.add(getBillBean("餐盒費：", amountUnit + data.getLunchbox()));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            billData.add(getBillBean("送貨費：", amountUnit + data.getDELIVERY_CHARGE()));
        }
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                billData.add(getBillBean(coupon.getCouponName() + "：", "-$" + coupon.getDiscount_amount()));
            }
        }
        BillItemAdapter adapter = new BillItemAdapter(billData);
        rvBill.setLayoutManager(new LinearLayoutManager(context));
        rvBill.setAdapter(adapter);
        //總金額
        setText(view, R.id.tv_total, amountUnit + data.getTOTAL_AMOUNT());
        //支付金額
        setText(view, R.id.tv_pay_amount_text, "支付金額：" + amountUnit + MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()));
        //支付類型：貨到付款，在線支付
        String payType = "";
        if (data.getPayType() == 1) {
            payType = "：積分支付";
        } else if (data.getPayType() == 2) {
            payType = "：支付寶";
        } else if (data.getPayType() == 3) {
            payType = "：财付通";
        } else if (data.getPayType() == 4) {
            payType = "：微信支付";
        } else if (data.getPayType() == 5) {
            payType = "：貨到付款";
        } else if (data.getPayType() == 6) {
            payType = "：其他支付";
        }
        if (data.getOrderPayType() == 1) {
            //貨到付款
            setText(view, R.id.tv_pay_type, "貨到付款");
        } else {
            setText(view, R.id.tv_pay_type, "在線支付" + payType);
        }
        //收貨時間
        setText(view, R.id.tv_delivery_time, data.getOrder_type() == 2 ? data.getSEND_TIME() : data.getTakeTime());
        if (data.getOrder_type() != 2) {
            //自取，隱藏地址和收貨人
            view.findViewById(R.id.tv_address).setVisibility(View.GONE);
            view.findViewById(R.id.tv_receiver).setVisibility(View.GONE);
        } else {
            //收貨地址
            setText(view, R.id.tv_address, context.getString(R.string.address) + data.getAddressDetail());
            //收貨人
            setText(view, R.id.tv_receiver, "收貨人：" + data.getRECEIVER());
        }
        //手機號
        setText(view, R.id.tv_phone, "手機號：" + data.getPHONE());
        //備註
        if (data.getRemark() != null && !data.getRemark().isEmpty()) {
            setText(view, R.id.tv_remark, "備註：" + data.getRemark());
            view.findViewById(R.id.tv_remark).setVisibility(View.VISIBLE);
        } else {
            view.findViewById(R.id.tv_remark).setVisibility(View.GONE);
        }
        if (data.getPRODUCT_NAME() != null) {
            RecyclerView rvFoodList = view.findViewById(R.id.rv_order_print_food);
            rvFoodList.setLayoutManager(new LinearLayoutManager(context));
            rvFoodList.setAdapter(new OtherOrderAdapter(context, data.getPRODUCT_NAME(), true));
        }
        if (data.getAddPoints() != 0 || data.getOldPoints() !=0 || data.getAddPoints() != 0) {
            tvAddPoints.setText("" + data.getNowPoints());
            tvNowPoint.setText("" + data.getOldPoints());
            tvOldPoints.setText("" + data.getAddPoints());
            tvAddPoints.setVisibility(View.VISIBLE);
            tvNowPoint.setVisibility(View.VISIBLE);
            tvOldPoints.setVisibility(View.VISIBLE);
        }
        return viewToBitmap(context, view);
    }

    private PrintBillBean getBillBean(String title, String value) {
        return new PrintBillBean(title, value);
    }

    private void setAmount(Double data, TextView tvText, TextView tvAmount, String amountUnit) {
        if (data <= 0) {
            tvText.setVisibility(View.GONE);
            tvAmount.setVisibility(View.GONE);
        } else {
            tvText.setVisibility(View.VISIBLE);
            tvAmount.setVisibility(View.VISIBLE);
            tvAmount.setText(amountUnit + data.toString());
        }
    }
}