package com.joe.print.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.RadioButton;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import com.gingersoft.gsa.cloud.constans.PrintConstans;

import java.util.List;

/**
 * Created by Wyh on 2020/1/16.
 */
public class PrinterListAdapter extends BaseQuickAdapter<PrinterDeviceBean, BaseViewHolder> {
    private Context mContext;
    private int selectPosition = -1;

    public PrinterListAdapter(@Nullable List<PrinterDeviceBean> data, Context mContext) {
        super(R.layout.printer_item, data);
        this.mContext = mContext;
    }

    @Override
    protected void convert(BaseViewHolder helper, PrinterDeviceBean item) {
        helper.setText(R.id.tv_printer_name, item.getName() + "");
        helper.setText(R.id.tv_printer_ip, String.format(mContext.getString(R.string.print_ip), item.getIp()));
        if (item.getPort() == null) {
            helper.setText(R.id.tv_printer_port, String.format(mContext.getString(R.string.print_port), ""));
        } else {
            helper.setText(R.id.tv_printer_port, String.format(mContext.getString(R.string.print_port), item.getPort() + ""));
        }
        ((RadioButton) helper.getView(R.id.cb_printer_item)).setChecked(item.getStatus() == 2);
        helper.getView(R.id.tv_default_print).setVisibility(item.getStatus() == 2 ? View.VISIBLE : View.GONE);

//        helper.setOnItemSelectedClickListener(R.id.layout_delete,)
//        helper.addOnClickListener(R.id.layout_delete);

        addChildClickViewIds(R.id.layout_delete);
    }


    public int getSelectPosition() {
        return selectPosition;
    }

    public void setSelectPosition(int selectPosition) {
        this.selectPosition = selectPosition;
    }

    public void notifyData(List<PrinterDeviceBean> data) {
//        this.mData = data;
        setNewInstance(data);
        super.notifyDataSetChanged();
    }
}
