package com.gingersoft.gsa.cloud.ui.bean.view;

import com.qmuiteam.qmui.widget.section.QMUISection.Model;

import java.util.Objects;

public class SectionItem implements Model<SectionItem> {
    private int image;
    private String text;

    public SectionItem(int image, String text) {
        this.image = image;
        this.text = text;
    }

    public String getText() {
        return text;
    }

    public int getImage() {
        return image;
    }

    @Override
    public SectionItem cloneForDiff() {
        return new SectionItem(getImage(), getText());
    }

    @Override
    public boolean isSameItem(SectionItem other) {
        return Objects.equals(text, other.text);
    }

    @Override
    public boolean isSameContent(SectionItem other) {
        return true;
    }
}
