package com.gingersoft.gsa.cloud.download.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import com.gingersoft.gsa.cloud.download.R;
import com.gingersoft.gsa.cloud.download.R2;
import com.gingersoft.gsa.cloud.download.di.component.DaggerDownloadComponent;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.download.mvp.contract.DownloadContract;
import com.gingersoft.gsa.cloud.download.mvp.presenter.DownloadPresenter;
import com.qmuiteam.qmui.widget.QMUITopBar;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/26/2019 17:59
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class DownloadActivity extends BaseActivity<DownloadPresenter> implements DownloadContract.View {

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.recycle_download)
    RecyclerView recycle_download;


    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerDownloadComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.download_data_activity_download; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mPresenter.initAdapter();
        mPresenter.downAllList();
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
//        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.white));
        mTopBar.addLeftImageButton(R.drawable.icon_back, R.id.iv_left_back).setOnClickListener(v -> finish());
        mTopBar.addRightTextButton("刷新", R.id.topbar).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mPresenter.downAllList();
            }
        });
        mTopBar.setTitle("數據下載");
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public RecyclerView getRecycleDownload() {
        return recycle_download;
    }

    @Override
    public void setDownLoadListAdapter(DefaultAdapter adapter) {
        recycle_download.setAdapter(adapter);
        initDownLoadRecycleView();
    }

    private void initDownLoadRecycleView() {
        LinearLayoutManager manager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        ArmsUtils.configRecyclerView(recycle_download, manager);
    }
}
