package com.gingersoft.gsa.cloud.ui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.R2;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.ThirdViewUtil;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/5/24
 * 修订历史：2018/5/24
 * 描述：
 */

public class IntergralKeypadDialog {

    private Context mContext;
    private Dialog dialog;

    @BindView(R2.id.lLayout_bg)
    LinearLayout lLayout_bg;

    @BindView(R2.id.tv_pay_method)
    TextView tv_pay_method;
    @BindView(R2.id.ed_value)
    EditText ed_value;

    @BindView(R2.id.btn_point)
    Button btn_point;

    public IntergralKeypadDialog(Context context) {
        this.mContext = context;
        initView();
    }

    private void initView() {
        // 获取Dialog布局
        View view = LayoutInflater.from(mContext).inflate(R.layout. table_dialog_intergral_keypad, null);

        ThirdViewUtil.bindTarget(this, view);//绑定

        // 定义Dialog布局和参数
        dialog = new Dialog(mContext, R.style.AlertDialogStyle);
        dialog.setContentView(view);
        dialog.setCancelable(true);

        // 调整dialog背景大小
        lLayout_bg.setLayoutParams(
                new FrameLayout.LayoutParams((int) (ArmsUtils.getScreenWidth(mContext) * 0.9), ViewGroup.LayoutParams.WRAP_CONTENT));

        btn_point.setVisibility(View.GONE);
    }


    public IntergralKeypadDialog builder() {
        return this;
    }


    @OnClick({R2.id.btn_add_0, R2.id.btn_add_10, R2.id.btn_add_20, R2.id.btn_add_50,
            R2.id.btn_100, R2.id.btn_200, R2.id.btn_500, R2.id.btn_1000,
            R2.id.btn_0, R2.id.btn_00, R2.id.btn_1, R2.id.btn_2, R2.id.btn_3,
            R2.id.btn_4, R2.id.btn_5, R2.id.btn_6, R2.id.btn_7,
            R2.id.btn_8, R2.id.btn_9, R2.id.btn_point, R2.id.btn_delete, R2.id.btn_sure})
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btn_0 || id == R.id.btn_00 || id == R.id.btn_1 || id == R.id.btn_2 || id == R.id.btn_3 || id == R.id.btn_4 || id == R.id.btn_5 ||
                id == R.id.btn_6 || id == R.id.btn_7 || id == R.id.btn_8 || id == R.id.btn_9) {

            String values = v.getTag().toString();

            String number = "0";
            if (!getInputNumber().isEmpty()) {
                number = getInputNumber();
            }
            if (!number.equals("0")) {
                ed_value.setText(number + values);
            } else {
                ed_value.setText(values);
            }
            ed_value.setSelection(0, number.length());
        } else if (id == R.id.btn_add_10 || id == R.id.btn_add_20 || id == R.id.btn_add_50) {
            int i2 = Integer.parseInt(v.getTag().toString());
            String valueOf = String.valueOf(i2);
            if (!TextUtils.isEmpty(getInputNumber())) {
                valueOf = String.valueOf(Double.parseDouble(getInputNumber()) + i2);
            }
            String[] spvalue = valueOf.split("[.]");
            if (spvalue.length > 1 && Integer.parseInt(spvalue[1]) == 0) {
                valueOf = spvalue[0];
            }
            ed_value.setText(valueOf);
        } else if (id == R.id.btn_add_0) {
            ed_value.setText("0");
        } else if (id == R.id.btn_100 || id == R.id.btn_200 || id == R.id.btn_500 || id == R.id.btn_1000) {
            int i3 = Integer.parseInt(v.getTag().toString());
            String values3 = String.valueOf(i3);
            ed_value.setText(values3);
        } else if (id == R.id.btn_point) {
            String intputStr = getInputNumber();
            if (!TextUtils.isEmpty(intputStr) && !intputStr.contains(".")) {
                ed_value.setText(intputStr + ".");
            }
        } else if (id == R.id.btn_delete) {
            Editable editable = ed_value.getText();
            if (editable.toString().length() > 0) {
                editable.delete(ed_value.getText().length() - 1, ed_value.getText().length());
            }
        } else if (id == R.id.btn_sure) {
            if (onComfirmListener != null && !TextUtils.isEmpty(getInputNumber())) {
                onComfirmListener.onComfirm(getInputNumber());
            }
            cancel();
        }
    }

    public IntergralKeypadDialog setCancelable(boolean cancelable) {
        dialog.setCancelable(cancelable);
        return this;
    }

    public String getInputNumber() {
        return ed_value.getText().toString().trim();
    }

    public IntergralKeypadDialog setPayMethod(String method) {
        tv_pay_method.setText(method);
        return this;
    }

    public void show() {
        dialog.show();
    }

    public void cancel() {
        dialog.dismiss();
    }

    private OnComfirmListener onComfirmListener;

    public IntergralKeypadDialog setComfirmListener(OnComfirmListener onComfirmListener) {
        this.onComfirmListener = onComfirmListener;
        return this;
    }

    public interface OnComfirmListener {
        void onComfirm(String money);
    }

}
