package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.WareHouseListBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/6
 * Time: 16:36
 * Use:庫存查詢的訂單列表
 */
public class WarehousingQueryAdapter extends BaseQuickAdapter<WareHouseListBean.WareHousingDataBean.PurchaseWarehousingOrderDetailsVO, BaseViewHolder> {

    private Context context;
    private int[] colors = new int[]{R.color.color_f9, R.color.white};

    public WarehousingQueryAdapter(Context context, List<WareHouseListBean.WareHousingDataBean.PurchaseWarehousingOrderDetailsVO> purchaseWarehousingOrderDetailsVosBeans) {
        super(R.layout.item_warehousing_query, purchaseWarehousingOrderDetailsVosBeans);
        addChildClickViewIds(R.id.tv_warehouse_item_inventory_quantity);
        this.context = context;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, WareHouseListBean.WareHousingDataBean.PurchaseWarehousingOrderDetailsVO item) {
        viewHolder.setText(R.id.tv_warehouse_item_ingredients_name, item.getName());
        viewHolder.setText(R.id.tv_warehouse_item_ingredients_species, item.getFoodCategoryName());
        viewHolder.setText(R.id.tv_warehouse_item_unit, item.getUnitName());
        viewHolder.setText(R.id.tv_warehouse_item_unit_price, item.getFoodPrice() + "");
        viewHolder.setText(R.id.tv_warehouse_item_inventory_quantity, item.getFoodNum() + "");
        viewHolder.setText(R.id.tv_warehouse_item_total_amount, item.getFoodAmount() + "");
        int textColorRes = getColor(R.color.color_3c);
        setTextColor(viewHolder, textColorRes);
        int colorRes = getColor(colors[viewHolder.getAdapterPosition() % 2]);
        viewHolder.setBackgroundColor(R.id.layout_warehousing, colorRes);
//        setBgColor(viewHolder, colorRes);
    }

    private void setBgColor(@NotNull BaseViewHolder viewHolder, int bgColorRes) {
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_ingredients_name, bgColorRes);
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_ingredients_species, bgColorRes);
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_supplier, bgColorRes);
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_unit, bgColorRes);
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_unit_price, bgColorRes);
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_inventory_quantity, bgColorRes);
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_total_amount, bgColorRes);
    }

    private void setTextColor(@NotNull BaseViewHolder viewHolder, int textColorRes) {
        viewHolder.setTextColor(R.id.tv_warehouse_item_ingredients_name, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_ingredients_species, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_supplier, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_unit, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_unit_price, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_inventory_quantity, textColorRes);
        viewHolder.setTextColor(R.id.tv_warehouse_item_total_amount, textColorRes);
    }

    private int getColor(int colorRes) {
        return ContextCompat.getColor(context, colorRes);
    }
}
