package com.gingersoft.gsa.cloud.common.core.user;

import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.core.user.info.UserInfo;
import com.gingersoft.gsa.cloud.common.core.user.state.LoginedState;
import com.gingersoft.gsa.cloud.common.core.user.state.LogoutState;
import com.gingersoft.gsa.cloud.common.core.user.state.UserState;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;

import lombok.Getter;
import lombok.Setter;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:用戶接口和狀態管理類
 */
@Getter
@Setter
public class UserContext {

    private static volatile UserContext sUserContextManger = null;

    /**
     * 用戶狀態
     */
    private UserState state = new LogoutState();

    /**
     * 用戶信息
     */
    private UserInfo info;


    private UserContext() {
        if (info == null) {
            info = new UserInfo();
        }
        info.setToken((String) SPUtils.get(UserConstans.token, ""));
        info.setUserId((Integer) SPUtils.get(UserConstans.memberId, 0));
        info.setUserName((String) SPUtils.get(UserConstans.memberName, ""));
    }

    public static UserContext newInstance() {
        if (sUserContextManger == null) {
            synchronized (UserContext.class) {
                if (sUserContextManger == null) {
                    sUserContextManger = new UserContext();
                }
            }
        }
        return sUserContextManger;
    }

    public void logined() {
        state.logined();
    }

    public void logOut() {
        state.logOut();
    }

    /**
     * 用戶是否登錄
     *
     * @return
     */
    public boolean isLogin() {
        if (state instanceof LoginedState) {
            return true;
        }
        return false;
    }

    public String getLoginToken() {
        if (info != null) {
            return info.getToken();
        }
        return (String) SPUtils.get(UserConstans.token, "");
    }

    public int getMemberId() {
        if (info != null) {
            return info.getUserId();
        }
        return (int) SPUtils.get(UserConstans.memberId, 0);
    }

    public String getMemberName() {
        if (info != null) {
            return info.getUserName();
        }
        return (String) SPUtils.get(UserConstans.memberName, "");
    }

    public void setUserInfo(UserInfo info) {
        if (info == null) {
            return;
        }
        this.info = info;
        SPUtils.put(UserConstans.token, info.getToken());
        SPUtils.put(UserConstans.memberId, info.getUserId());
        SPUtils.put(UserConstans.memberName, info.getUserName());
    }

    public void removeUserInfo() {
        SPUtils.remove(UserConstans.token);
        SPUtils.remove(UserConstans.memberId);
        SPUtils.remove(UserConstans.memberName);
        //刪除用戶信息的同時 將品牌，餐廳信息一起刪除
        RestaurantInfoManager.newInstance().removeBrandInfo();
        RestaurantInfoManager.newInstance().removeResturantInfo();
    }

}
