package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.OrderDetailsModule;
import com.gingersoft.supply_chain.mvp.contract.OrderDetailsContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.order.OrderDetailsFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/22/2020 16:57
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = OrderDetailsModule.class, dependencies = AppComponent.class)
public interface OrderDetailsComponent {
    void inject(OrderDetailsFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        OrderDetailsComponent.Builder view(OrderDetailsContract.View view);

        OrderDetailsComponent.Builder appComponent(AppComponent appComponent);

        OrderDetailsComponent build();
    }
}