package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.PackageSpecificationModule;
import com.gingersoft.supply_chain.mvp.contract.PackageSpecificationContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.PackageSpecificationFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/24/2020 18:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = PackageSpecificationModule.class, dependencies = AppComponent.class)
public interface PackageSpecificationComponent {
    void inject(PackageSpecificationFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        PackageSpecificationComponent.Builder view(PackageSpecificationContract.View view);

        PackageSpecificationComponent.Builder appComponent(AppComponent appComponent);

        PackageSpecificationComponent build();
    }
}