package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.gingersoft.supply_chain.mvp.ui.fragment.order.PurchaseListFragment;
import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.PurchaseListModule;
import com.gingersoft.supply_chain.mvp.contract.PurchaseListContract;

import com.jess.arms.di.scope.FragmentScope;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/02/2020 16:05
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = PurchaseListModule.class, dependencies = AppComponent.class)
public interface PurchaseListComponent {
    void inject(PurchaseListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        PurchaseListComponent.Builder view(PurchaseListContract.View view);

        PurchaseListComponent.Builder appComponent(AppComponent appComponent);

        PurchaseListComponent build();
    }
}