package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.gingersoft.supply_chain.mvp.ui.fragment.supplier.SupplierListFragment;
import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.SupplierListModule;
import com.gingersoft.supply_chain.mvp.contract.SupplierListContract;

import com.jess.arms.di.scope.FragmentScope;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 17:41
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = SupplierListModule.class, dependencies = AppComponent.class)
public interface SupplierListComponent {
    void inject(SupplierListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        SupplierListComponent.Builder view(SupplierListContract.View view);

        SupplierListComponent.Builder appComponent(AppComponent appComponent);

        SupplierListComponent build();
    }
}