package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiCheckInputBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/26
 * Time: 15:20
 * Use:
 */
public class MultiCheckProvider<T extends InfoMultiBean> extends BaseItemProvider<T> {

    public MultiCheckProvider(Context context) {

    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_MULTIPLE_CHECKBOX;
    }

    @Override
    public int getLayoutId() {
        return com.gingersoft.gsa.cloud.common.R.layout.multi_checkbox_input;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T t) {
        MultiCheckInputBean infoMultiBean = (MultiCheckInputBean) t;
        //是否顯示必選
        baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.multi_required, !infoMultiBean.isRequired());
        //設置標題
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowTitle())) {
            baseViewHolder.setText(com.gingersoft.gsa.cloud.common.R.id.tv_multi_title, infoMultiBean.getShowTitle());
        } else {
            baseViewHolder.setText(com.gingersoft.gsa.cloud.common.R.id.tv_multi_title, "");
        }
        baseViewHolder.setImageResource(com.gingersoft.gsa.cloud.common.R.id.iv_multi_check_img, infoMultiBean.getIconId());
        CheckBox checkBox = baseViewHolder.getView(com.gingersoft.gsa.cloud.common.R.id.cb_multi_check);
        checkBox.setChecked(infoMultiBean.isChecked());
        if (infoMultiBean.isDefault()) {
            baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.cb_multi_check, true);
            baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.tv_multi_default, false);
        } else {
            baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.cb_multi_check, false);
            baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.tv_multi_default, true);
        }

        EditText editText = baseViewHolder.getView(com.gingersoft.gsa.cloud.common.R.id.ed_multi_value);
        initEditLimit(infoMultiBean, editText);
        setEditText(infoMultiBean, editText);

        ImageView ivClear = baseViewHolder.getView(com.gingersoft.gsa.cloud.common.R.id.iv_clear_multi_content);
        ivClear.setOnClickListener(v -> editText.setText(""));

        infoMultiBean.setTextWatcher(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                List<T> data = getAdapter().getData();
                data.get(baseViewHolder.getAdapterPosition()).setShowValue(s + "");
                if (s != null && TextUtil.isNotEmptyOrNullOrUndefined(s.toString())) {
                    baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.iv_clear_multi_content, false);
                } else {
                    editText.setHint(data.get(baseViewHolder.getAdapterPosition()).getHintText());
                    baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.iv_clear_multi_content, true);
                }
            }
        });
        editText.addTextChangedListener(infoMultiBean.getTextWatcher());

        editText.setFocusable(infoMultiBean.isEdit());
        if(infoMultiBean.isEdit()){
            editText.setTextColor(ContextCompat.getColor(context, com.gingersoft.gsa.cloud.common.R.color.color_3c));
        } else {
            editText.setTextColor(ContextCompat.getColor(context, com.gingersoft.gsa.cloud.common.R.color.color_c9));
        }
    }

    private void setEditText(MultiCheckInputBean infoMultiBean, EditText editText) {
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowValue())) {
            editText.setText(infoMultiBean.getShowValue());
        } else {
            editText.setHint(infoMultiBean.getHintText());
            editText.setText("");
        }
    }

    private void initEditLimit(MultiCheckInputBean infoMultiBean, EditText editText) {
        if (infoMultiBean.getTextWatcher() != null) {
            editText.removeTextChangedListener(infoMultiBean.getTextWatcher());
        }

        if (infoMultiBean.getInputFilters() != null) {
            editText.setFilters(infoMultiBean.getInputFilters());
        } else {
            editText.setFilters(editText.getFilters());
        }

        if (infoMultiBean.getInputType() != -1) {
            editText.setInputType(infoMultiBean.getInputType());
        } else {
            editText.setInputType(editText.getInputType());
        }
    }

}
