package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.glide.GlideUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.UploadPicMultiBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:52
 * Use:
 */
public class MultiUploadPicProvider<T extends InfoMultiBean> extends BaseItemProvider<T> {

    public static final int CHOOSE_PHOTO = 101;

    public MultiUploadPicProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.EDIT_FOOD_ITEM_UPLOAD_PIC;
    }

    @Override
    public int getLayoutId() {
        return com.gingersoft.gsa.cloud.common.R.layout.item_multi_upload_pic;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T infoMultiBean) {
        ImageView pic = baseViewHolder.getView(com.gingersoft.gsa.cloud.common.R.id.iv_multi_upload_pic);
        //是否顯示必選
        baseViewHolder.setGone(com.gingersoft.gsa.cloud.common.R.id.multi_required, !infoMultiBean.isRequired());
        //設置標題
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowTitle())) {
            baseViewHolder.setText(com.gingersoft.gsa.cloud.common.R.id.tv_multi_title, infoMultiBean.getShowTitle());
        } else {
            baseViewHolder.setText(com.gingersoft.gsa.cloud.common.R.id.tv_multi_title, "");
        }
        if (infoMultiBean instanceof UploadPicMultiBean) {
            UploadPicMultiBean uploadPicMultiBean = (UploadPicMultiBean) infoMultiBean;
            List<String> picUrl = uploadPicMultiBean.getPicUrl();
            if (picUrl != null && picUrl.size() > 0) {
                GlideUtils.display(context, pic, picUrl.get(0));
            } else if(uploadPicMultiBean.getDrawableId() != 0){
                Glide.with(context).load(uploadPicMultiBean.getDrawableId()).into(pic);
           }
        }
    }
}
