/*
 * Decompiled with CFR 0.152.
 */
package com.hyweb.n5.lib.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.hyweb.n5.lib.exception.NoInitScannerException;
import com.hyweb.n5.server.aidl.IOnScanCallback;
import com.hyweb.n5.server.aidl.IScannerService;
import java.util.List;

public class ScannerUtil {
    private static IScannerService mScannerService;
    private static ServiceConnection mServiceConnection;

    static {
        mServiceConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                mScannerService = null;
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                mScannerService = IScannerService.Stub.asInterface(service);
            }
        };
    }

    private static void bindScannerService(Context context) {
        Intent implicitIntent;
        Context localContext = context.getApplicationContext();
        PackageManager pm = context.getPackageManager();
        List resolveInfo = pm.queryIntentServices(implicitIntent = new Intent("com.hyweb.n5.server.aidl.IScannerService"), 0);
        if (resolveInfo == null || resolveInfo.size() != 1) {
            return;
        }
        ResolveInfo serviceInfo = (ResolveInfo)resolveInfo.get(0);
        String packageName = serviceInfo.serviceInfo.packageName;
        String className = serviceInfo.serviceInfo.name;
        ComponentName component = new ComponentName(packageName, className);
        Intent explicitIntent = new Intent(implicitIntent);
        explicitIntent.setComponent(component);
        localContext.bindService(explicitIntent, mServiceConnection, 1);
    }

    public static void unbindScannerService(Context context) {
        context.unbindService(mServiceConnection);
    }

    public static void initScanner(Context context) throws NoInitScannerException, RemoteException {
        ScannerUtil.bindScannerService(context);
        if (mScannerService == null) {
            throw new NoInitScannerException();
        }
    }

    public static void startScan() throws RemoteException {
        mScannerService.scan();
    }

    public static void registerCallback(IOnScanCallback cb) throws RemoteException {
        mScannerService.registerCallback(cb);
    }

    public static void unregisterCallback(IOnScanCallback cb) throws RemoteException {
        mScannerService.unregisterCallback(cb);
    }
}

