package com.gingersoft.gsa.cloud.main.di.component;

import dagger.BindsInstance;
import dagger.Component;
import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.main.di.module.ReportListModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.ReportListContract;

import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.ReportListFragment;
import com.jess.arms.di.scope.FragmentScope;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/27/2021 12:07
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = ReportListModule.class, dependencies = AppComponent.class)
public interface ReportListComponent {
    void inject(ReportListFragment fragment);
    @Component.Builder
    interface Builder {
        @BindsInstance
        ReportListComponent.Builder view(ReportListContract.View view);
        ReportListComponent.Builder appComponent(AppComponent appComponent);
        ReportListComponent build();
    }
}