package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerLanguageComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.LanguageContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.LanguageType;
import com.gingersoft.gsa.cloud.main.mvp.presenter.LanguagePresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.LanguageAdapter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;
import java.util.ArrayList;
import java.util.List;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 07/11/2020 14:51
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class LanguageActivity extends BaseActivity<LanguagePresenter> implements LanguageContract.View {


    @BindView(R2.id.topbar_language)
    QMUITopBar mTopBar;

    @BindView(R2.id.recycler_language)
    RecyclerView recycler_language;

    private LanguageAdapter mLanguageAdapter;
    private List<LanguageType> mLanguageTypeList = new ArrayList<>();

    private LanguageType mCurrentLanguageType;

    /**
     * 系統類型
     * 0：gsa
     * 1：gsa（平闆）
     */
    private int systemType = 0;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerLanguageComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.main_activity_language; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initAdapter();
        initItemListener();
        mPresenter.getLanguageByBrandId(RestaurantInfoManager.newInstance().getBrandId());
    }

    private void initAdapter() {
        if (mLanguageAdapter == null) {
            mLanguageAdapter = new LanguageAdapter(mLanguageTypeList);
            recycler_language.setAdapter(mLanguageAdapter);
        }
    }

    private void initItemListener() {
        mLanguageAdapter.setOnItemClickListener((OnItemClickListener) (adapter, view, position) -> mPresenter.getByLanguageId(mLanguageTypeList, position, systemType, adapter));
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                killMyself();
            }
        });
        mTopBar.setTitle(LanguageUtils.get_language_system( "funcSelect.settlement", "語言")).setTextColor(ArmsUtils.getColor(this, R.color.theme_white_color));
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void returnLanguageData(List<LanguageType> languageList) {

        if (mLanguageTypeList.size() != 0) {
            mLanguageTypeList.clear();
        }

        mLanguageTypeList.addAll(languageList);
        mLanguageAdapter.notifyDataSetChanged();
    }


}
