package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.StorageListModule;
import com.gingersoft.supply_chain.mvp.contract.StorageListContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.inventory.StorageListFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/10/2020 18:09
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = StorageListModule.class, dependencies = AppComponent.class)
public interface StorageListComponent {
    void inject(StorageListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        Builder view(StorageListContract.View view);

        Builder appComponent(AppComponent appComponent);

        StorageListComponent build();
    }
}