package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.os.Build;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.ui.adapter.SecondCategoryAdapter;
import com.google.android.flexbox.FlexWrap;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.util.XPopupUtils;

import java.util.List;

import lombok.val;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/11
 * Time: 11:37
 * Use:
 */
public class ShowSecondCategoryPopup extends AttachPopupView {

    private final int width;
    private final List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTreesList;
    private final int defaultSelect;
    /**
     * 當前顯示的是几級分類
     */
    private int categoryLevel = 2;

    public ShowSecondCategoryPopup(@NonNull Context context, int width, int defaultSelect, List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTreesList) {
        super(context);
        this.width = width;
        this.defaultSelect = defaultSelect;
        this.foodCategoryTreesList = foodCategoryTreesList;
        bgDrawableMargin = 0;
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout.layout_popup_category_recycler;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        RecyclerView recyclerView = findViewById(R.id.rv_purchase_list_content);
        FlexboxLayoutManager flexboxLayoutManager = new FlexboxLayoutManager(getContext());
        flexboxLayoutManager.setFlexWrap(FlexWrap.WRAP);
        recyclerView.setLayoutManager(flexboxLayoutManager);
        SecondCategoryAdapter secondCategoryAdapter = new SecondCategoryAdapter(getContext(), foodCategoryTreesList);
        secondCategoryAdapter.setSelectedIndex(defaultSelect);
        secondCategoryAdapter.setOnItemClickListener((adapter, view, position) -> {
            if (categoryLevel == 2) {
                //二級分類
                onCategoryClickListener.onClick(secondCategoryAdapter.getItem(position), position, categoryLevel);
                val foodCategoryTrees = foodCategoryTreesList.get(position).getFoodCategoryTrees();
                //有三級分類就顯示三級分類，沒有三級分類，關閉彈窗
                if (foodCategoryTrees != null && foodCategoryTrees.size() > 0) {
                    //顯示三級分類
                    categoryLevel = 3;
                    secondCategoryAdapter.setNewInstance(foodCategoryTreesList.get(position).getFoodCategoryTrees());
                } else {
                    //沒有三級分類，關閉彈窗
                    dismiss();
                }
            } else {
                //當前是三級分類點擊
                onCategoryClickListener.onClick(secondCategoryAdapter.getItem(position), position, categoryLevel);
                dismiss();
            }
        });
        recyclerView.setAdapter(secondCategoryAdapter);
        defaultOffsetY = 0;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            attachPopupContainer.setElevation(XPopupUtils.dp2px(getContext(), 2));
        }
    }

    private OnCategoryClickListener onCategoryClickListener;

    public ShowSecondCategoryPopup setOnCategoryClickListener(OnCategoryClickListener onCategoryClickListener) {
        this.onCategoryClickListener = onCategoryClickListener;
        return this;
    }

    @Override
    public int getMinimumWidth() {
        return width;
    }

    @Override
    protected int getMaxWidth() {
        return width;
    }

    public interface OnCategoryClickListener {
        void onClick(OrderCategoryBean.FoodCategoryTrees foodCategoryTrees, int position, int categoryLevel);
    }
}
