package com.gingersoft.gsa.cloud.order.commodity;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.database.DiscountConstact;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.order.bean.discount.MemberWalletCoupon;
import com.gingersoft.gsa.cloud.order.bean.response.OrderResponse;
import com.gingersoft.gsa.cloud.order.discount.MemberWalletCouponDiscount;
import com.gingersoft.gsa.cloud.order.discount.NomalDiscount;
import com.gingersoft.gsa.cloud.order.order.MealOrder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：訂單實體類
 */
@Data
public class OrderDetail implements Commodity, Serializable, Cloneable {
    private static final long serialVersionUID = -958791295551999853L;
    /**
     * 是否选择
     * 0 未选中
     * 1 被选中但不是主体
     * 2 作为主体被选中
     * 3 由三级菜单进入选中全部
     */
    private int selected = 0;
    //是否食品
    private boolean isIsfood = true;
    //父級下標
    private int parentIndex = 0;
    //自身下標
    private int myIndex = 0;
    //是否是新添加的食品（未送單）
    private boolean isNew = true;
    //是否顯示
    private boolean visible = true;
    //新点后是否自动展开
    private int autoMod = 0;
    //作用于套餐下子食品的限制数量
    private int limitQty = 0;
    //折扣比例
    private double PERCENTAGE = 0.00;
    //套餐编號
    private long comid;
    //細項編號
    private long mid;
    //修改数量前的数量
    private int changeBeforeQty = 0;
    //当前食品是否有子项
    private boolean hasChild = false;
    //背景色
    private int bgColor;
    //字體色
    private int fontColor;
    //是否组合商品 1-组合商品 2-组合商品的子商品
    private int ComboLevel = 0;
    //套餐食品是否自動跟餐
    private boolean isComboAuto = false;
    /**
     * 動態的最大選中數
     */
    private String currentMaxNumber = "";
    /**
     * 删除食品相关
     */
    //该食品是否修改过
    private boolean isModify = false;
    //修改食品前的数量
    private int modifyBeforeNumber = 0;
    //取消食品备注
    private String cancelReason;
    //取消食品原因ID
    private int reasonId;
    //取消食品数量
    private int cancelNumber;
    //"food" or "discount" or "modifiy"
    private int prop = FOOD_PROP;
    /**
     * 訂單Item類型
     * 1:主食品
     * 2:套餐
     * 3:細項
     * 4:折扣
     * 5:優惠券
     */
    public static final byte FOOD_PROP = 1;
    public static final byte COMBO_PROP = 2;
    public static final byte MODIFIER_PROP = 3;
    public static final byte DISCOUNT_PROP = 4;
    public static final byte COUPON_PROP = 5;
    /***
     * 層級
     * 1:主食品
     * 2:子項or細項
     * 3:細項
     */
    private int itemType;
    /**
     * ID
     */
    private long id;
    /**
     * 父级ID
     */
    private long parentId;
    /**
     * 订单ID
     */
    private long orderId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品id
     */
    private long productId;
    /**
     * 父级商品ID
     */
    private long parentProductId;
    /**
     * 商品組id
     */
    private long topId;
    /**
     * 總價格(已經x數量)
     */
    private double price = 0;
    /**
     * 單價
     */
    private double unit_price = 0;
    /**
     * 成本價
     */
    private double cost = 0;
    /**
     * 餐盒費
     */
    private double lunchboxPrice;
    /**
     * 細項價格
     */
    private double itemsPrice;
    /**
     * 數量
     */
    private int number;
    /**
     * 已經使用優惠卷卷號列表逗號分割
     */
    private String userCouponNo;
    /**
     * 类型#1:优惠卷;2:商品;3:菜品;4:细项;5:折扣;
     */
    private byte type;
    public static final byte COUPON_TYPE = 1;
    public static final byte FOOD_TYPE = 3;
    public static final byte MODIFIER_TYPE = 4;
    public static final byte DISCOUNT_TYPE = 5;
    /**
     *
     */
    private String qmUseData;
    /**
     * 备注
     */
    private String remark;
    /**
     * 细项(食品种类#食品id#详细分类ID#详细ID#名称#单价#位置索引#数量#细项总价格#posFid)
     */
    private String items;
    /**
     * 創建時間
     */
    private Date createTime = new Date();
    /**
     * 打印設定, 用逗號分隔, *=切紙
     */
    private String printSeting;
    /**
     * 是否免服務費 0：否，1：是
     */
    private byte freeServiceCharge;
    /**
     * 是否参与折扣#0:不參與;1:參與;
     */
    private long ablediscount = 1;
    /**
     * 是否参与折上折 0：否，1：是
     */
    private byte additionalDiscount = 1;
    /**
     * 折扣實體
     */
    private Discount discount;
    /**
     * 會員優惠券實體
     */
    private MemberWalletCoupon walletCoupon;
    /**
     * 折扣狀態#0:沒有折扣;1:有折扣未送單;2:折扣全部已送單;
     */
    private int discountStatus;
    /**
     * 是否参与服務費#0:不參與;1:參與;
     **/
    private byte scAble = 1;
    /**
     * 額外食品加分
     */
    private double pointsAdd;
    /**
     * 換購食品所需積分
     */
    private double pointsRedeem;

    /**
     * 食品組
     */
    private String ftName;
    /**
     * 自定義組
     */
    private String majorName;
    /**
     * 状态#0:正常;1:删除;
     */
    private Byte status = STATUS_NORMAL;

    /**
     * 状态#0:正常;1:删除;
     */
    public static final byte STATUS_NORMAL = 0;
    public static final byte STATUS_DELETE = 1;


    /**
     * 廚房單打印主項
     */
    private long ktPrintMainItem;

    /**
     * 0=系統顏色, 1=黑色, 2=紅色
     */
    private long printFont;
    /**
     * 當金額=0時, 是否打印在帳單上
     */
    private long printToBill;
    /**
     * 0食品清单打印 账单打印//1食品清单不打印 账单不打印//2食品清单打印 账单不打印//3食品清单不打印 账单打印
     */
    private long printTo;
    /**
     * 是否打印价格
     */
    private long ktShowPrice;
    /**
     * 自定義类型 #100=不可自定义 #101=自定义食品名称及金额 #102=自定义食品金额
     */
    private Integer customType;


    public OrderDetail() {
    }

    public OrderDetail(String productName, double price, int number) {
        this.productName = productName;
        this.price = price;
        this.number = number;
    }

    public OrderDetail(OrderDetail orderDetail) {
        this.selected = orderDetail.selected;
        this.isIsfood = orderDetail.isIsfood;
        this.parentIndex = orderDetail.parentIndex;
        this.myIndex = orderDetail.myIndex;
        this.isNew = orderDetail.isNew;
        this.visible = orderDetail.visible;
        this.autoMod = orderDetail.autoMod;
        this.limitQty = orderDetail.limitQty;
        this.PERCENTAGE = orderDetail.PERCENTAGE;
        this.comid = orderDetail.comid;
        this.mid = orderDetail.mid;
        this.changeBeforeQty = orderDetail.changeBeforeQty;
        this.hasChild = orderDetail.hasChild;
        this.bgColor = orderDetail.bgColor;
        this.fontColor = orderDetail.fontColor;
        this.ComboLevel = orderDetail.ComboLevel;
        this.isComboAuto = orderDetail.isComboAuto;
        this.prop = orderDetail.prop;
        this.itemType = orderDetail.itemType;
        this.id = orderDetail.id;
        this.parentId = orderDetail.parentId;
        this.orderId = orderDetail.orderId;
        this.productName = orderDetail.productName;
        this.productId = orderDetail.productId;
        this.topId = orderDetail.topId;
        this.price = orderDetail.price;
        this.unit_price = orderDetail.unit_price;
        this.lunchboxPrice = orderDetail.lunchboxPrice;
        this.itemsPrice = orderDetail.itemsPrice;
        this.number = orderDetail.number;
        this.userCouponNo = orderDetail.userCouponNo;
        this.type = orderDetail.type;
        this.qmUseData = orderDetail.qmUseData;
        this.remark = orderDetail.remark;
        this.items = orderDetail.items;
        this.createTime = orderDetail.createTime;
        this.ablediscount = orderDetail.ablediscount;
        this.scAble = orderDetail.scAble;
        this.ftName = orderDetail.ftName;
        this.majorName = orderDetail.majorName;
        this.freeServiceCharge = orderDetail.freeServiceCharge;
        this.additionalDiscount = orderDetail.additionalDiscount;
        this.discount = orderDetail.discount;
        this.walletCoupon = orderDetail.walletCoupon;
        this.discountStatus = orderDetail.discountStatus;
        this.status = orderDetail.status;
        this.printSeting = orderDetail.printSeting;
        this.ktPrintMainItem = orderDetail.ktPrintMainItem;
        this.currentMaxNumber = orderDetail.currentMaxNumber;
        this.pointsAdd = orderDetail.pointsAdd;
        this.pointsRedeem = orderDetail.pointsRedeem;
        this.isModify = orderDetail.isModify;
        this.modifyBeforeNumber = orderDetail.modifyBeforeNumber;
        this.cancelReason = orderDetail.cancelReason;
        this.reasonId = orderDetail.reasonId;
        this.cancelNumber = orderDetail.cancelNumber;
        this.customType = orderDetail.customType;
    }

    public boolean isModify() {
        if (!isNew && modifyBeforeNumber != 0 && number != modifyBeforeNumber) {
            isModify = true;
        } else {
            isModify = false;
        }
        return isModify;
    }

    /**
     * @param type             是食品清單還是賬單 0清單  1賬單
     * @param productnameBeans 訂單食品項
     * @return
     */
    public static List<OrderDetail> productMameBeanToOrderDetail(int type, List<OrderDetails.DataBean.PRODUCTNAMEBean> productnameBeans) {
        List<OrderDetail> orderDetailList = new ArrayList<>();
        if (productnameBeans != null) {
            for (OrderDetails.DataBean.PRODUCTNAMEBean productnameBean : productnameBeans) {
                //遍歷食品信息，查詢是否需要打印

                //沒有價格的情況下，勾選了就打印，沒勾選就不打印
                //有價格的情況下，就會打印，不管有沒有勾選，如果是細項就只打印細項，如果是主項就只打印主項
                //
                //只要勾選了打印，不論有沒有價格都會打印
                //細項只要勾選了，主項就會打印

                //如果細項勾選了，則不管主項的配置，都會打印主項
                //如果細項沒勾選，就判斷是否有價格，修改isPrint
                boolean isCheck = false;
                boolean isCheck2 = false;//二級細項
                if (productnameBean.getChild() != null) {
                    for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : productnameBean.getChild()) {
                        if (childBeanX != null) {
                            //判斷是否選擇了打印至賬單，為true的時候會同時打印主項
                            if (childBeanX.getPrintToBill() == 1) {
                                isCheck = true;
                                break;
                            }
                            if (childBeanX.getChild() != null) {
                                for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
                                    //判斷是否選擇了打印至賬單，為true的時候會同時打印上一項細項
                                    if (childBean.getPrintToBill() == 1) {
                                        isCheck2 = true;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                if (isCheck || isPrintTo(productnameBean.getPrintToBill(), Double.valueOf(productnameBean.getPRICE()), productnameBean.getPrintTo(), type)) {
                    // 細項勾選了||主項勾選了||主項價格不為0    主項就會打印
                    orderDetailList.add(getOrderDetailByProductnameBean(productnameBean.getPRODUCT_NAME(), Integer.parseInt(productnameBean.getNum()), Double.valueOf(productnameBean.getPRICE()), 1));
                    addFoodItem(type, orderDetailList, productnameBean, isCheck2);
                } else {
                    //主項沒勾選&&主項價格為0&&細項也沒勾選
                    //那麼，不打印主項，查詢細項如果有價格就會打印
                    addFoodItem(type, orderDetailList, productnameBean, isCheck2);
                }
            }
        }
        return orderDetailList;
    }

    /**
     * 添加細項
     *
     * @param type
     * @param orderDetailList
     * @param productnameBean
     * @param isCheck2
     */
    private static void addFoodItem(int type, List<OrderDetail> orderDetailList, OrderDetails.DataBean.PRODUCTNAMEBean productnameBean, boolean isCheck2) {
        if (productnameBean.getChild() == null) {
            return;
        }

        for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : productnameBean.getChild()) {
            if (childBeanX != null) {
                if (isCheck2 || isPrintToBill(childBeanX.getPrintToBill(), Double.valueOf(childBeanX.getPRICE()))) {
                    // 二級細項勾選了||細項勾選了||細項價格不為0    細項就會打印
                    orderDetailList.add(getOrderDetailByProductnameBean(childBeanX.getPRODUCT_NAME(), Integer.parseInt(childBeanX.getNum()), Double.valueOf(childBeanX.getPRICE()), 2));
                    addSecondFood(type, orderDetailList, childBeanX);
                } else {
                    //二級細項沒勾選 && 細項也沒勾選了 && 細項價格為0
                    //那麼，不打印細項，查詢二級細項如果有價格就會打印
                    addSecondFood(type, orderDetailList, childBeanX);
                }
            }
        }
    }

    /**
     * 添加二級細項
     *
     * @param type
     * @param orderDetailList
     * @param childBeanX
     */
    private static void addSecondFood(int type, List<OrderDetail> orderDetailList, OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX) {
        if (childBeanX.getChild() != null) {
            for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
                if (isPrintToBill(childBeanX.getPrintToBill(), Double.valueOf(childBeanX.getPRICE()))) {
                    //如果二級細項勾選了||價格不為0  二級細項就打印
                    orderDetailList.add(getOrderDetailByProductnameBean(childBean.getPRODUCT_NAME(), Integer.parseInt(childBean.getNum()), Double.valueOf(childBean.getPRICE()), 3));
                }
            }
        }
    }


    private static boolean isPrintTo(int printToBill, double price, int printTo, int type) {
        //printTo和price不為0 都會打印
        return isPrintToBill(printToBill, price) || isPrint(printTo, type);
    }

    private static boolean isPrintToBill(int printToBill, double price) {
        return !(printToBill == 0 && price == 0);
    }

    /**
     * 是否打印
     *
     * @param printTo
     * @param type    食品清單還是賬單 0 食品清單，1 賬單
     * @return
     */
    public static boolean isPrint(int printTo, int type) {
        if (printTo == 0) {
            //清單和賬單都打印
            return true;
        } else if (printTo == 1) {
            //食品清单不打印 账单不打印
            return false;
        } else if (printTo == 2) {
            //食品清单打印 账单不打印
            return type == 0;
        } else if (printTo == 3) {
            //食品清单不打印 账单打印
            return type == 1;
        }
        return true;
    }


    /**
     * @param foodName
     * @param foodNum
     * @param foodPrice
     * @param itemType  1主食品，2細項，3二級細項
     * @return
     */
    private static OrderDetail getOrderDetailByProductnameBean(String foodName, int foodNum, double foodPrice, int itemType) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(foodName);
        orderDetail.setNumber(foodNum);
        orderDetail.setPrice(foodPrice);
        orderDetail.setItemType(itemType);
        return orderDetail;
    }


    /**
     * 已送單食品轉換
     *
     * @param orderList
     * @return
     */
    public static List<OrderDetail> orderTransOrderDetails(List<OrderResponse.OrderDetailsBean> orderList) {
        List<OrderDetail> orderDetailList = new ArrayList<>();
        OrderDetail parentOrderDetail = null;
        long parentId = 0;
        //每個套餐食品折扣總額
        double discountSourcePrice = 0;
        //已到結尾或者下一個食品是主食品
        for (int i = 0; i < orderList.size(); i++) {
            OrderResponse.OrderDetailsBean orderDetailsBean = orderList.get(i);

            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setOrderId(orderDetailsBean.getOrderId());
            orderDetail.setId(orderDetailsBean.getId());
            orderDetail.setProductId(orderDetailsBean.getProductId());
            orderDetail.setParentId(orderDetailsBean.getParentId());
            orderDetail.setTopId(orderDetailsBean.getTopId());
            orderDetail.setProductName(orderDetailsBean.getProductName());
            orderDetail.setNumber(orderDetailsBean.getNumber());
            orderDetail.setUnit_price(orderDetailsBean.getPrice());
            orderDetail.setPrice(orderDetailsBean.getPrice() * orderDetailsBean.getNumber());
            orderDetail.setVisible(orderDetailsBean.getStatus() == 0);
            orderDetail.setPrintSeting(orderDetailsBean.getPrintSetIng());
//            orderDetail.setAutomod(foods.getAutomod());
            orderDetail.setKtPrintMainItem(orderDetailsBean.getKtPrintMainItem());
            orderDetail.setPrintFont(orderDetailsBean.getPrintFont());
            orderDetail.setPrintToBill(orderDetailsBean.getPrintToBill());
            orderDetail.setPrintTo(orderDetailsBean.getPrintTo());
            orderDetail.setKtShowPrice(orderDetailsBean.getKtShowPrice());
            orderDetail.setAblediscount(orderDetailsBean.getAblediscount());
            orderDetail.setIsfood(orderDetailsBean.getType() == FOOD_TYPE);
            orderDetail.setNew(false);
            orderDetail.setType(orderDetailsBean.getType());
            orderDetail.setItemType(getItemType(orderDetailsBean, parentOrderDetail));
            orderDetail.setAblediscount(orderDetailsBean.getAblediscount());
            orderDetail.setScAble(orderDetailsBean.getScAble());
            orderDetail.setPointsAdd(orderDetailsBean.getPointsAdd());
            orderDetail.setPointsRedeem(orderDetailsBean.getPointsRedeem());
            orderDetailList.add(orderDetail);

//            if (orderDetail.isIsfood()) {
//                parentOrderDetail = null;
//            }

            if (orderDetail.getItemType() == 1) {
                parentId = orderDetail.getId();
                discountSourcePrice = 0;
            }

            if (orderDetailsBean.getDiscountList() != null) {
                //累加折扣總額
                discountSourcePrice = MoneyUtil.sum(discountSourcePrice, orderDetail.getPrice());
                //食品折扣狀態為已送單
                orderDetail.setDiscountStatus(2);
                //往下找
                int nextIndex = i + 1;
                if (orderList.size() == nextIndex || orderList.get(nextIndex).getParentId() == 0) {
                    //已到結尾或者下一個食品是主食品
                    List<OrderResponse.OrderDetailsBean.RestaurantDiscountVO> discountList = orderDetailsBean.getDiscountList();
                    if (discountList != null) {
                        for (OrderResponse.OrderDetailsBean.RestaurantDiscountVO discount : discountList) {
                            if (discount == null) {
                                continue;
                            }
                            orderDetailList.add(discountTransOrderDetail(getDiscountItem(discount), false, parentId, discountSourcePrice));
                        }
                    }
                }
            } else {
                orderDetail.setDiscountStatus(0);
            }

            if (orderDetail.isIsfood()) {
                parentOrderDetail = orderDetail;
            }
        }
        return orderDetailList;
    }

    private static Discount getDiscountItem(OrderResponse.OrderDetailsBean.RestaurantDiscountVO discountBean) {
        Discount discount = new Discount();
        discount.setId(discountBean.getDiscountId());
        discount.setDiscountRecordId(discountBean.getId());
        discount.setDiscountValue(discountBean.getDiscountValue());
        discount.setAmount(discountBean.getDiscountAmount());
        if (discountBean.getType() == 2) {
            discount.setAbstractDiscountType(DiscountConstact.WALLET_COUPON_TYPE);
        } else {
            discount.setAbstractDiscountType(DiscountConstact.DISCOUNT_TYPE);
        }
        discount.setType(discountBean.getType());
        discount.setRemark(discountBean.getRemark());
        return discount;
    }

    public static int getItemType(OrderResponse.OrderDetailsBean orderDetailsBean, OrderDetail parentOrderDetail) {
        if (orderDetailsBean != null) {
            if (orderDetailsBean.getParentId() == 0) {
                return 1;
            }
            if (orderDetailsBean.getParentId() != 0 && orderDetailsBean.getType() == FOOD_TYPE) {
                return 2;
            }
            if (orderDetailsBean.getParentId() != 0 && orderDetailsBean.getType() == DISCOUNT_TYPE) {
                return 2;
            }
            if (parentOrderDetail != null && orderDetailsBean.getParentId() != 0) {
                if (parentOrderDetail.getId() == orderDetailsBean.getParentId()) {
                    //是父級
                    if (parentOrderDetail.getParentId() == 0 && orderDetailsBean.getType() == FOOD_TYPE) {
                        //第二層子食品
                        return 2;
                    }
                    if (parentOrderDetail.getParentId() == 0 && orderDetailsBean.getType() == DISCOUNT_TYPE) {
                        //第二層子食品
                        return 2;
                    }
                    if (parentOrderDetail.getParentId() != 0 && orderDetailsBean.getType() == MODIFIER_TYPE) {
                        //第三層細項
                        return 3;
                    }
                }
                return 3;
            }
        }
        return 1;
    }

    /**
     * 主食品轉換
     *
     * @param food
     * @param number
     * @return
     */
    public static OrderDetail foodTransOrderDetails(Food food, int number) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(food.getFoodName());
        orderDetail.setTopId(food.getTopId());
        orderDetail.setId(0);
        orderDetail.setParentId(0);
        orderDetail.setProductId(food.getId());
//        orderDetail.setParentId(foods.getParentId());
        orderDetail.setUnit_price(food.getPrice());
        orderDetail.setPrice(number * orderDetail.getUnit_price());
        orderDetail.setCost(food.getCost());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MealOrder.getInstance().getOrderId());
        orderDetail.setPrintSeting(food.getPrintSeting());
        orderDetail.setIsfood(true);
        orderDetail.setNew(true);
        orderDetail.setType(FOOD_TYPE);
        orderDetail.setItemType(1);
        orderDetail.setProp(FOOD_PROP);
        orderDetail.setCustomType(food.ableDiscountCastCustomType());
        orderDetail.setAblediscount(food.getAbleDiscount());
        orderDetail.setAutoMod(food.getAutoMod());
        int comboLevel = food.isComboFood() ? 1 : 0;
        orderDetail.setComboLevel(comboLevel);
        orderDetail.setCurrentMaxNumber(food.getCurrentMaxNumber());
        orderDetail.setScAble(food.getServiceCharge());
        orderDetail.setPointsAdd(food.getPointsAdd());
        orderDetail.setPointsRedeem(food.getPointsRedeem());
        return orderDetail;
    }

    /**
     * 套餐食品轉換
     *
     * @param foodCombo
     * @param number
     * @param prop
     * @param isRvMealClicked
     * @return
     */
    public static OrderDetail comboTransOrderDetail(ComboItem foodCombo, long id, long productId, int number,
                                                    int prop, boolean isRvMealClicked) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(foodCombo.getName());
//        if (foodCombo.getFid() != null) {
//            orderDetail.setTopId(foodCombo.getFid());
        orderDetail.setTopId(foodCombo.getComId());
//        }
        if (foodCombo.getComId() != null) {
            orderDetail.setProductId(foodCombo.getFid());
        }
        orderDetail.setParentId(id);
        orderDetail.setParentProductId(productId);
        orderDetail.setUnit_price(foodCombo.getPrice());
        orderDetail.setPrice(number * orderDetail.getUnit_price());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MealOrder.getInstance().getOrderId());
        orderDetail.setComid(foodCombo.getComId());
        orderDetail.setIsfood(true);
        orderDetail.setNew(true);
        orderDetail.setType(FOOD_TYPE);
        orderDetail.setItemType(2);
        orderDetail.setProp(prop);
        orderDetail.setPrintSeting(foodCombo.getPrintSeting());
        orderDetail.setAblediscount(foodCombo.getAblediscount());
//        orderDetail.setComboAuto(foodCombo.isAutoMode());
        if (isRvMealClicked) {
            //手动点击细项 才将子食品作为主体被选中
            orderDetail.setSelected(2);
        } else {
            orderDetail.setSelected(1);
        }
        orderDetail.setCurrentMaxNumber(foodCombo.getCurrentMaxNumber());
        orderDetail.setScAble((byte) foodCombo.getServiceCharge());
        orderDetail.setPointsAdd(foodCombo.getPointsAdd());
        orderDetail.setPointsRedeem(foodCombo.getPointsRedeem());
        return orderDetail;
    }


    /**
     * 細項轉換
     *
     * @param modifier
     * @param number
     * @return
     */
    public static OrderDetail modifierTransOrderDetail(Modifier modifier, long id, long productId, int number) {
        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(modifier.getModifierName());
        orderDetail.setKtPrintMainItem(modifier.getKtPrintMainItem());
        orderDetail.setPrintSeting(modifier.getPrintSet());
        orderDetail.setTopId(modifier.getTopId());
        orderDetail.setParentId(id);
        orderDetail.setProductId(modifier.getMid());
        orderDetail.setParentProductId(productId);
        orderDetail.setUnit_price(modifier.getPrice());
        orderDetail.setPrice(number * orderDetail.getUnit_price());
        orderDetail.setCost(modifier.getCost());
        orderDetail.setNumber(number);
        orderDetail.setOrderId(MealOrder.getInstance().getOrderId());
        orderDetail.setMid(modifier.getMid());
        orderDetail.setIsfood(false);
        orderDetail.setNew(true);
        orderDetail.setItemType(3);
        orderDetail.setType(MODIFIER_TYPE);
        orderDetail.setProp(MODIFIER_PROP);
        orderDetail.setAblediscount(modifier.getAbleDisCount());
        //手动点击细项 才将子食品作为主体被选中
        orderDetail.setSelected(2);
        orderDetail.setCurrentMaxNumber(modifier.getCurrentMaxNumber());
        return orderDetail;
    }

    /**
     * 折扣轉換
     *
     * @param discount
     * @return
     */
    public static OrderDetail discountTransOrderDetail(Discount discount, boolean isNew, long id, double sourcePrice) {

        double discountPrice = NomalDiscount.calculationDiscount(discount, sourcePrice);

        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(discount.getRemark());
        orderDetail.setId(discount.getId());
        orderDetail.setTopId(id);
        orderDetail.setParentId(id);
        orderDetail.setProductId(discount.getId());
        orderDetail.setNumber(1);
        orderDetail.setPrice(discountPrice);
        orderDetail.setUnit_price(discountPrice);
        orderDetail.setOrderId(MealOrder.getInstance().getOrderId());
        orderDetail.setIsfood(false);
        orderDetail.setNew(isNew);
        orderDetail.setType(DISCOUNT_TYPE);
        orderDetail.setProp(DISCOUNT_PROP);
        orderDetail.setSelected(2);
        orderDetail.setItemType(2);

        orderDetail.setDiscount(discount);

        return orderDetail;
    }

    /**
     * 會員優惠券轉換
     *
     * @param walletCoupon
     * @return
     */
    public static OrderDetail couponTransOrderDetail(MemberWalletCoupon walletCoupon, boolean isNew, long id, double sourcePrice) {

        double discountPrice = MemberWalletCouponDiscount.calculationCoupon(walletCoupon, sourcePrice);

        OrderDetail orderDetail = new OrderDetail();
        orderDetail.setProductName(walletCoupon.getCouponTypeName());
        orderDetail.setId(walletCoupon.getCouponId());
        orderDetail.setTopId(id);
        orderDetail.setParentId(id);
        orderDetail.setProductId(walletCoupon.getCouponId());
        orderDetail.setNumber(1);
        orderDetail.setPrice(discountPrice);
        orderDetail.setUnit_price(discountPrice);
        orderDetail.setOrderId(MealOrder.getInstance().getOrderId());
        orderDetail.setIsfood(false);
        orderDetail.setNew(isNew);
        orderDetail.setType(COUPON_TYPE);
        orderDetail.setProp(COUPON_PROP);
        orderDetail.setSelected(2);
        orderDetail.setItemType(2);

        orderDetail.setWalletCoupon(walletCoupon);

        return orderDetail;
    }

    public static List<OrderDetail> transNewOrderDetails(List<OrderDetail> orderDetailList) {
        List<OrderDetail> newOrderList = new ArrayList<>();
        for (OrderDetail orderDetail : orderDetailList) {
            newOrderList.add(new OrderDetail(orderDetail));
//            try {
//                newOrderList.add(orderDetail.clone());
//            } catch (CloneNotSupportedException e) {
//                e.printStackTrace();
//            }
        }
        return newOrderList;
    }

    /**
     * 此食品是否包含折扣
     *
     * @param orderDetails
     * @param start_position
     * @param end_position
     * @return
     */
    public static boolean hasFoodDiscount(List<OrderDetail> orderDetails, int start_position,
                                          int end_position) {
        boolean hasDiscount = false;
        if (start_position == 0 && end_position == 0) {
            return hasDiscount;
        }
        for (int i = orderDetails.size() - 1; i >= 0; i--) {
            if (start_position <= i && i <= end_position) {
                OrderDetail orderDetail1 = orderDetails.get(i);
                //添加折扣實體
                if (orderDetail1.getType() == OrderDetail.DISCOUNT_TYPE) {
                    hasDiscount = true;
                    break;
                }
            }
        }
        return hasDiscount;
    }

    public static List<OrderDetail> productNameBeanTransOrderDetail(List<OrderDetails.DataBean.PRODUCTNAMEBean> orderDetails) {
        if (orderDetails != null) {
            List<OrderDetail> orderDetailList = new ArrayList<>();
            for (OrderDetails.DataBean.PRODUCTNAMEBean bean : orderDetails) {
                OrderDetail orderData = new OrderDetail();
                orderData.setProductName(bean.getPRODUCT_NAME());
                orderData.setPrice(Double.parseDouble(Objects.requireNonNull(bean.getPRICE())));
                orderData.setNumber(Integer.parseInt(Objects.requireNonNull(bean.getNum())));
                orderData.setPrintSeting(bean.getPrintseting());
                orderData.setItemType(1);
                if (bean.getChild() != null) {
                    for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : bean.getChild()) {
                        OrderDetail childOrderData = new OrderDetail();
                        childOrderData.setProductName(childBeanX.getPRODUCT_NAME());
                        childOrderData.setPrice(Double.parseDouble(Objects.requireNonNull(childBeanX.getPRICE())));
                        childOrderData.setNumber(Integer.parseInt(Objects.requireNonNull(childBeanX.getNum())));
                        childOrderData.setPrintSeting(childBeanX.getPrintseting());
                        childOrderData.setItemType(2);
                        if (childBeanX.getChild() != null) {
                            for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
                                OrderDetail childOrderData2 = new OrderDetail();
                                childOrderData2.setProductName(childBean.getPRODUCT_NAME());
                                childOrderData2.setPrice(Double.parseDouble(Objects.requireNonNull(childBean.getPRICE())));
                                childOrderData2.setNumber(Integer.parseInt(Objects.requireNonNull(childBean.getNum())));
                                childOrderData2.setPrintSeting(childBean.getPrintseting());
                                childOrderData2.setItemType(3);
                                orderDetailList.add(childOrderData2);
                            }
                        }
                        orderDetailList.add(childOrderData);
                    }
                }
                orderDetailList.add(orderData);
            }
            return orderDetailList;
        }
        return null;
    }


    public boolean canAbleDiscount() {
        int ad = (int) (ablediscount % 2);
        if (ablediscount == 1 || ablediscount % 2 != 0) {
            return true;
        }
        return false;
    }

    @NonNull
    @Override
    protected OrderDetail clone() throws CloneNotSupportedException {
        OrderDetail orderDetail = (OrderDetail) super.clone();
        //引用類型需要深拷貝
        if (discount != null) {
            Discount copyDiscount = discount.clone();
            orderDetail.setDiscount(copyDiscount);
        }
        return orderDetail;
    }
}
