/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

class OutputLog {
    private static final int LOGIF_RETURN_NONE = 0;
    private static final int LOGIF_FUNC_IN = 0;
    private static final int LOGIF_FUNC_OUT_WITH_RET = 1;
    private static final int LOGIF_FUNC_OUT_WITHOUT_RET = 2;
    private static final int LOGIF_FUNC_CB_EVENT = 3;
    private static final int LOGIF_FUNC_OP_INFO = 4;
    private static final String LOGIF_OP_STR_BT_PAIRED_OK = "Bluetooth is paired.";
    private static final String LOGIF_OP_STR_BT_PAIRED_NG = "Bluetooth isn't paired.";

    OutputLog() {
    }

    protected static native int nativeReadLogSettings(String var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    protected static native void nativeLogOutput(int var0, long var1, String var3, int var4, String var5);

    public static void outputLogCallFunction(String methodName, long handle, Object ... param) {
        OutputLog.processOutputLogData(0, handle, methodName, param);
    }

    public static void outputLogReturnFunction(String methodName, long handle, int result, Object ... param) {
        OutputLog.processOutputLogDataWithResult(1, handle, methodName, result, param);
    }

    public static void outputException(String methodName, long handle, Exception ex) {
        OutputLog.processOutputExceptionLog(2, handle, methodName, ex);
    }

    public static void outputLogEvent(String methodName, long handle, Object ... param) {
        OutputLog.processOutputLogData(3, handle, methodName, param);
    }

    public static void outputLogInfo(long handle, Object ... param) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String callHierarchyName = "";
        int length = stackTrace.length;
        for (int i = 0; i < 3; ++i) {
            if (length < 4 + i || stackTrace[3 + i].getFileName() == null) continue;
            callHierarchyName = callHierarchyName + " at " + stackTrace[3 + i].getFileName() + ":" + stackTrace[3 + i].getLineNumber();
        }
        OutputLog.processOutputLogData(4, handle, callHierarchyName, param);
    }

    public static void readLogSettings(Context context) {
        String path = "";
        if (null != context) {
            try {
                path = context.getExternalFilesDir(null).toString();
            }
            catch (Exception e) {
                path = "";
            }
        }
        String deviceOs = "Android";
        String deviceOsVer = Build.VERSION.RELEASE;
        String deviceName = Build.MODEL;
        try {
            String deviceKernelVer = System.getProperty("os.version");
            if (deviceOsVer != null && deviceKernelVer != null) {
                deviceOsVer = deviceOsVer + "(KernelVersion: " + deviceKernelVer + ")";
            }
        }
        catch (Exception deviceKernelVer) {
            // empty catch block
        }
        long totalRamSize = OutputLog.getTotalMemorySize(Environment.getDataDirectory());
        long freeRamSize = OutputLog.getFreeMemorySize(Environment.getDataDirectory());
        long freeStorageSize = OutputLog.getFreeMemorySize(Environment.getExternalStorageDirectory());
        String ramSize = String.format("%d/%d", freeRamSize, totalRamSize);
        String storageSize = String.format("%d", freeStorageSize);
        try {
            OutputLog.nativeReadLogSettings(path, "NOT_USE", "NOT_USE", deviceOs, deviceOsVer, deviceName, ramSize, storageSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processOutputLogData(int type, long handle, String methoddName, Object[] params) {
        String paramString = "(";
        String token = "";
        if (params != null) {
            int count = 0;
            for (count = 0; count < params.length; ++count) {
                paramString = paramString + token;
                paramString = params[count] == null ? paramString + "null" : (params[count] instanceof String ? paramString + (String)params[count] : paramString + params[count].toString());
                token = ", ";
            }
        }
        paramString = paramString + ")";
        OutputLog.nativeLogOutput(type, handle, methoddName, 0, paramString);
    }

    private static void processOutputLogDataWithResult(int type, long handle, String methoddName, int result, Object[] params) {
        String paramString = "(";
        String token = "";
        if (params != null) {
            int count = 0;
            for (count = 0; count < params.length; ++count) {
                paramString = paramString + token;
                paramString = params[count] == null ? paramString + "null" : (params[count] instanceof String ? paramString + (String)params[count] : paramString + params[count].toString());
                token = ", ";
            }
        }
        paramString = paramString + ")";
        OutputLog.nativeLogOutput(type, handle, methoddName, result, paramString);
    }

    private static void processOutputExceptionLog(int type, long handle, String methodName, Exception ex) {
        StringWriter messageBuf = new StringWriter();
        PrintWriter pw = new PrintWriter(messageBuf);
        ex.printStackTrace(pw);
        pw.flush();
        OutputLog.nativeLogOutput(type, handle, methodName, 0, messageBuf.toString());
    }

    private static long getTotalMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getTotalSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }

    private static long getFreeMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getFreeSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }
}

