/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.linedisplay;

import android.content.Context;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.linedisplay.DisplayStatusInfo;
import com.epson.epos2.linedisplay.ReceiveListener;
import java.lang.reflect.Method;

public class LineDisplay {
    private long mDisplayHandle = 0L;
    private Context mContext = null;
    private ReceiveListener mReceiveListener;
    private ConnectionListener mConnectionListener;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    public static final int PARAM_DEFAULT = -2;
    public static final int DM_D110 = 0;
    public static final int DM_D210 = 1;
    public static final int DM_D30 = 2;
    public static final int SCROLL_OVERWRITE = 0;
    public static final int SCROLL_VERTICAL = 1;
    public static final int SCROLL_HORIZONTAL = 2;
    public static final int MOVE_TOP_LEFT = 0;
    public static final int MOVE_TOP_RIGHT = 1;
    public static final int MOVE_BOTTOM_LEFT = 2;
    public static final int MOVE_BOTTOM_RIGHT = 3;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_UNDERLINE = 1;
    public static final int LANG_EN = 0;
    public static final int LANG_JA = 1;
    public static final int MARQUEE_WALK = 0;
    public static final int MARQUEE_PLACE = 1;
    public static final int BRIGHTNESS_20 = 0;
    public static final int BRIGHTNESS_40 = 1;
    public static final int BRIGHTNESS_60 = 2;
    public static final int BRIGHTNESS_100 = 3;
    private static int connection;

    private native int nativeEpos2CreateHandle(int var1, long[] var2);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    private native int nativeEpos2Disconnect(long var1);

    protected native DisplayStatusInfo nativeEpos2GetStatus(long var1);

    protected native int nativeEpos2SendData(long var1);

    protected native int nativeEpos2ClearCommandBuffer(long var1);

    protected native int nativeEpos2AddInitialize(long var1);

    protected native int nativeEpos2AddCreateWindow(long var1, long var3, long var5, long var7, long var9, long var11, int var13);

    protected native int nativeEpos2AddDestroyWindow(long var1, long var3);

    protected native int nativeEpos2AddSetCurrentWindow(long var1, long var3);

    protected native int nativeEpos2AddClearCurrentWindow(long var1);

    protected native int nativeEpos2AddSetCursorPosition(long var1, long var3, long var5);

    protected native int nativeEpos2AddMoveCursorPosition(long var1, int var3);

    protected native int nativeEpos2AddSetCursorType(long var1, int var3);

    protected native int nativeEpos2AddText(long var1, String var3);

    protected native int nativeEpos2AddTextLang(long var1, String var3, int var4);

    protected native int nativeEpos2AddTextPosition(long var1, String var3, long var4, long var6);

    protected native int nativeEpos2AddTextPositionLang(long var1, String var3, long var4, long var6, int var8);

    protected native int nativeEpos2AddReverseText(long var1, String var3);

    protected native int nativeEpos2AddReverseTextLang(long var1, String var3, int var4);

    protected native int nativeEpos2AddReverseTextPosition(long var1, String var3, long var4, long var6);

    protected native int nativeEpos2AddReverseTextPositionLang(long var1, String var3, long var4, long var6, int var8);

    protected native int nativeEpos2AddMarqueeText(long var1, String var3, int var4, long var5, long var7, long var9, int var11);

    protected native int nativeEpos2AddSetBlink(long var1, long var3);

    protected native int nativeEpos2AddSetBrightness(long var1, int var3);

    protected native int nativeEpos2AddShowClock(long var1);

    protected native int nativeEpos2AddCommand(long var1, byte[] var3);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    public LineDisplay(int displaySeries, Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("LineDisplay", displaySeries, context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("LineDisplay", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeDisplayInstance(displaySeries);
        this.outputLogReturnFunction("LineDisplay", 0, displaySeries, context);
    }

    protected void initializeDisplayInstance(int displaySeries) throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(displaySeries, bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mDisplayHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mReceiveListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mDisplayHandle != 0L) {
                this.nativeEpos2Disconnect(this.mDisplayHandle);
                this.nativeEpos2DestroyHandle(this.mDisplayHandle);
                this.mDisplayHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mDisplayHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mDisplayHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mDisplayHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    public void sendData() throws Epos2Exception {
        this.outputLogCallFunction("sendData", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendData(this.mDisplayHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendData", ex);
            this.outputLogReturnFunction("sendData", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("sendData", 0, new Object[0]);
    }

    public DisplayStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        DisplayStatusInfo status = this.nativeEpos2GetStatus(this.mDisplayHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public void clearCommandBuffer() {
        this.outputLogCallFunction("clearCommandBuffer", new Object[0]);
        if (this.mDisplayHandle != 0L) {
            this.nativeEpos2ClearCommandBuffer(this.mDisplayHandle);
        }
        this.outputLogReturnFunction("clearCommandBuffer", 0, new Object[0]);
    }

    public void addInitialize() throws Epos2Exception {
        this.outputLogCallFunction("addInitialize", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = 0;
            errStatus = this.nativeEpos2AddInitialize(this.mDisplayHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addInitialize", ex);
            this.outputLogReturnFunction("addInitialize", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addInitialize", 0, new Object[0]);
    }

    public void addCreateWindow(int number, int x, int y, int width, int height, int scrollMode) throws Epos2Exception {
        this.outputLogCallFunction("addCreateWindow", number, x, y, width, height, scrollMode);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddCreateWindow(this.mDisplayHandle, number, x, y, width, height, scrollMode);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCreateWindow", ex);
            this.outputLogReturnFunction("addCreateWindow", ex.getErrorStatus(), number, x, y, width, height, scrollMode);
            throw ex;
        }
        this.outputLogReturnFunction("addCreateWindow", 0, number, x, y, width, height, scrollMode);
    }

    public void addDestroyWindow(int number) throws Epos2Exception {
        this.outputLogCallFunction("addDestroyWindow", number);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDestroyWindow(this.mDisplayHandle, number);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addDestroyWindow", ex);
            this.outputLogReturnFunction("addDestroyWindow", ex.getErrorStatus(), number);
            throw ex;
        }
        this.outputLogReturnFunction("addDestroyWindow", 0, number);
    }

    public void addSetCurrentWindow(int number) throws Epos2Exception {
        this.outputLogCallFunction("addSetCurrentWindow", number);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetCurrentWindow(this.mDisplayHandle, number);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetCurrentWindow", ex);
            this.outputLogReturnFunction("addSetCurrentWindow", ex.getErrorStatus(), number);
            throw ex;
        }
        this.outputLogReturnFunction("addSetCurrentWindow", 0, number);
    }

    public void addClearCurrentWindow() throws Epos2Exception {
        this.outputLogCallFunction("addClearCurrentWindow", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddClearCurrentWindow(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addClearCurrentWindow", ex);
            this.outputLogReturnFunction("addClearCurrentWindow", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addClearCurrentWindow", 0, new Object[0]);
    }

    public void addSetCursorPosition(int x, int y) throws Epos2Exception {
        this.outputLogCallFunction("addSetCursorPosition", x, y);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetCursorPosition(this.mDisplayHandle, x, y);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetCursorPosition", ex);
            this.outputLogReturnFunction("addSetCursorPosition", ex.getErrorStatus(), x, y);
            throw ex;
        }
        this.outputLogReturnFunction("addSetCursorPosition", 0, x, y);
    }

    public void addMoveCursorPosition(int position) throws Epos2Exception {
        this.outputLogCallFunction("addMoveCursorPosition", position);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddMoveCursorPosition(this.mDisplayHandle, position);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addMoveCursorPosition", ex);
            this.outputLogReturnFunction("addMoveCursorPosition", ex.getErrorStatus(), position);
            throw ex;
        }
        this.outputLogReturnFunction("addMoveCursorPosition", 0, position);
    }

    public void addSetCursorType(int type) throws Epos2Exception {
        this.outputLogCallFunction("addSetCursorType", type);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetCursorType(this.mDisplayHandle, type);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetCursorType", ex);
            this.outputLogReturnFunction("addSetCursorType", ex.getErrorStatus(), type);
            throw ex;
        }
        this.outputLogReturnFunction("addSetCursorType", 0, type);
    }

    public void addText(String data) throws Epos2Exception {
        this.outputLogCallFunction("addText", data);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddText(this.mDisplayHandle, data);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data);
    }

    public void addText(String data, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addText", data, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddTextLang(this.mDisplayHandle, data, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data, lang);
    }

    public void addText(String data, int x, int y) throws Epos2Exception {
        this.outputLogCallFunction("addText", data, x, y);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddTextPosition(this.mDisplayHandle, data, x, y);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data, x, y);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data, x, y);
    }

    public void addText(String data, int x, int y, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addText", data, x, y, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddTextPositionLang(this.mDisplayHandle, data, x, y, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data, x, y, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data, x, y, lang);
    }

    public void addReverseText(String data) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseText(this.mDisplayHandle, data);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data);
    }

    public void addReverseText(String data, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseTextLang(this.mDisplayHandle, data, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data, lang);
    }

    public void addReverseText(String data, int x, int y) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data, x, y);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseTextPosition(this.mDisplayHandle, data, x, y);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data, x, y);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data, x, y);
    }

    public void addReverseText(String data, int x, int y, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data, x, y, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseTextPositionLang(this.mDisplayHandle, data, x, y, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data, x, y, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data, x, y, lang);
    }

    public void addMarqueeText(String data, int format, int unitWait, int repeatWait, int repeatCount, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addMarqueeText", data, format, unitWait, repeatWait, repeatCount, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddMarqueeText(this.mDisplayHandle, data, format, unitWait, repeatWait, repeatCount, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addMarqueeText", ex);
            this.outputLogReturnFunction("addMarqueeText", ex.getErrorStatus(), data, format, unitWait, repeatWait, repeatCount, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addMarqueeText", 0, data, format, unitWait, repeatWait, repeatCount, lang);
    }

    public void addSetBlink(int interval) throws Epos2Exception {
        this.outputLogCallFunction("addSetBlink", interval);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetBlink(this.mDisplayHandle, interval);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetBlink", ex);
            this.outputLogReturnFunction("addSetBlink", ex.getErrorStatus(), interval);
            throw ex;
        }
        this.outputLogReturnFunction("addSetBlink", 0, interval);
    }

    public void addSetBrightness(int brightness) throws Epos2Exception {
        this.outputLogCallFunction("addSetBrightness", brightness);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetBrightness(this.mDisplayHandle, brightness);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetBrightness", ex);
            this.outputLogReturnFunction("addSetBrightness", ex.getErrorStatus(), brightness);
            throw ex;
        }
        this.outputLogReturnFunction("addSetBrightness", 0, brightness);
    }

    public void addShowClock() throws Epos2Exception {
        this.outputLogCallFunction("addShowClock", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddShowClock(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addShowClock", ex);
            this.outputLogReturnFunction("addShowClock", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addShowClock", 0, new Object[0]);
    }

    public void addCommand(byte[] data) throws Epos2Exception {
        this.outputLogCallFunction("addCommand", new Object[]{data});
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddCommand(this.mDisplayHandle, data);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCommand", ex);
            this.outputLogReturnFunction("addCommand", ex.getErrorStatus(), new Object[]{data});
            throw ex;
        }
        this.outputLogReturnFunction("addCommand", 0, new Object[]{data});
    }

    public void setReceiveEventListener(ReceiveListener target) {
        this.outputLogCallFunction("setReceiveEventListener", target);
        if (this.mDisplayHandle != 0L) {
            this.mReceiveListener = target != null ? target : null;
        }
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mDisplayHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mDisplayHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mDisplayHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mDisplayHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mDisplayHandle == 0L) {
            return;
        }
        this.mConnectionListener = listener != null ? listener : null;
    }

    private void onDispReceive(int code) {
        this.outputLogCallFunction("onDispReceive", code, this);
        if (null != this.mReceiveListener) {
            this.mReceiveListener.onDispReceive(this, code);
            this.outputLogEvent("onDispReceive", "code->", code);
        }
        this.outputLogReturnFunction("onDispReceive", 0, code, this);
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }
}

