/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Build;
import com.epson.epsonio.EpsonIoException;
import com.epson.epsonio.bluetooth.AdapterHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class NetBt {
    private static Map<Integer, BluetoothSocket> mSocketMap = Collections.synchronizedMap(new HashMap());
    private static final int M_MAX_SOCKET_NUM = 16;
    private static final int M_INVALID_HANDLE_INDEX = -1;
    private static final int M_IO_INTERVAL_MSEC = 10;
    private static final int M_MAX_SENT_SIZE_AT_ONCE = 4096;
    private static final int M_SDK_INT = Build.VERSION.SDK_INT;
    private static final UUID M_SERIAL_PORT_SERVICE_CLASS_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static Class<?> mClassOutputLog = null;
    private static Method mOutputLogInfoMethod = null;
    private static Field mBtPairedOkField = null;
    private static Field mBtPairedNgField = null;
    private static String mBtPairedOk = null;
    private static String mBtPairedNg = null;

    public static int open(String deviceName, String deviceSettings, int[] btHandle) throws IOException {
        int errStatus;
        BluetoothSocket socket;
        block31: {
            BluetoothAdapter adapter = null;
            BluetoothDevice device = null;
            socket = null;
            errStatus = 255;
            AdapterHandler mHandler = new AdapterHandler();
            int minimumApiLevel = 10;
            int nOpenRetry = 0;
            if (null == deviceName) {
                return 1;
            }
            if (null != deviceSettings) {
                return 1;
            }
            if (null == btHandle) {
                return 1;
            }
            if (0 == btHandle.length) {
                return 1;
            }
            btHandle[0] = -1;
            if (!BluetoothAdapter.checkBluetoothAddress((String)deviceName.toUpperCase(Locale.US))) {
                return 1;
            }
            try {
                if (mHandler.getLooper().getThread().getId() != Thread.currentThread().getId()) {
                    try {
                        adapter = mHandler.getAdapter();
                    }
                    catch (EpsonIoException e) {
                        return e.getStatus();
                    }
                } else {
                    adapter = BluetoothAdapter.getDefaultAdapter();
                }
                if (null == adapter) {
                    return 2;
                }
                if (!adapter.isEnabled()) {
                    return 2;
                }
                try {
                    device = adapter.getRemoteDevice(deviceName);
                }
                catch (IllegalArgumentException e) {
                    return 1;
                }
                if (10 <= M_SDK_INT) {
                    try {
                        socket = device.createInsecureRfcommSocketToServiceRecord(M_SERIAL_PORT_SERVICE_CLASS_UUID);
                    }
                    catch (IOException e2) {
                        socket = device.createRfcommSocketToServiceRecord(M_SERIAL_PORT_SERVICE_CLASS_UUID);
                    }
                } else {
                    socket = device.createRfcommSocketToServiceRecord(M_SERIAL_PORT_SERVICE_CLASS_UUID);
                }
                if (null == socket) {
                    errStatus = 2;
                    break block31;
                }
                for (int i = 0; -1 == btHandle[0] && i < 16; ++i) {
                    if (null != mSocketMap.get(i)) continue;
                    btHandle[0] = i;
                }
                for (nOpenRetry = 0; nOpenRetry < 3; ++nOpenRetry) {
                    if (-1 == btHandle[0]) {
                        errStatus = 6;
                        continue;
                    }
                    try {
                        adapter.cancelDiscovery();
                        socket.connect();
                        NetBt.outputLogInfo(mBtPairedOk, deviceName);
                        errStatus = 0;
                        break;
                    }
                    catch (IOException e) {
                        NetBt.outputLogInfo(mBtPairedNg, deviceName, e);
                        errStatus = 2;
                        Thread.sleep(100L);
                    }
                }
            }
            catch (Exception e) {
                errStatus = 2;
            }
        }
        if (errStatus == 0) {
            mSocketMap.put(btHandle[0], socket);
        } else {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                socket = null;
            }
            if (-1 != btHandle[0]) {
                btHandle[0] = -1;
            }
        }
        return errStatus;
    }

    public static int close(int btHandle) {
        BluetoothSocket socket = null;
        try {
            socket = mSocketMap.get(btHandle);
            if (null == socket) {
                return 6;
            }
            socket.close();
            socket = null;
            mSocketMap.remove(btHandle);
        }
        catch (Exception e) {
            return 255;
        }
        return 0;
    }

    public static int kill(int btHandle) {
        BluetoothSocket socket = null;
        try {
            socket = mSocketMap.get(btHandle);
            if (null == socket) {
                return 6;
            }
            socket.close();
            socket = null;
        }
        catch (Exception e) {
            return 255;
        }
        return 0;
    }

    public static int write(int btHandle, byte[] data, int offset, int dataSize, int timelimit, int[] sentSize) {
        OutputStream outStream;
        byte[] writeData;
        if (null == sentSize || 1 > sentSize.length) {
            return 1;
        }
        sentSize[0] = 0;
        if (0 > offset) {
            return 1;
        }
        if (0 > dataSize) {
            return 1;
        }
        if (0 > timelimit) {
            return 1;
        }
        BluetoothSocket socket = null;
        try {
            socket = mSocketMap.get(btHandle);
            if (null == socket) {
                return 6;
            }
        }
        catch (Exception e) {
            return 255;
        }
        if (0 == dataSize) {
            return 0;
        }
        int i = offset + dataSize;
        if (0 > i) {
            return 255;
        }
        if (null == data || data.length < offset + dataSize) {
            return 1;
        }
        try {
            writeData = new byte[dataSize];
            System.arraycopy(data, offset, writeData, 0, dataSize);
        }
        catch (Exception e) {
            return 5;
        }
        try {
            outStream = socket.getOutputStream();
        }
        catch (Exception e) {
            return 3;
        }
        long startTime = System.currentTimeMillis();
        int requestSendSize = 0;
        sentSize[0] = 0;
        while (sentSize[0] < dataSize) {
            requestSendSize = dataSize - sentSize[0] < 4096 ? dataSize - sentSize[0] : 4096;
            try {
                outStream.write(writeData, sentSize[0], requestSendSize);
                sentSize[0] = sentSize[0] + requestSendSize;
            }
            catch (Exception e) {
                if (e.getClass().equals(IOException.class)) {
                    NetBt.outputLogInfo(mBtPairedNg, socket.getRemoteDevice().getAddress(), e);
                } else {
                    NetBt.outputLogInfo(e);
                }
                if (System.currentTimeMillis() - startTime > (long)timelimit) {
                    return 4;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e2) {
                    return 255;
                }
            }
        }
        return 0;
    }

    public static int read(int btHandle, byte[] data, int offset, int dataSize, int timelimit, int[] readSize) {
        int resultReadSize;
        InputStream inStream;
        if (null == readSize || 1 > readSize.length) {
            return 1;
        }
        readSize[0] = 0;
        if (0 > offset) {
            return 1;
        }
        if (0 > dataSize) {
            return 1;
        }
        if (0 > timelimit) {
            return 1;
        }
        BluetoothSocket socket = null;
        try {
            socket = mSocketMap.get(btHandle);
            if (null == socket) {
                return 6;
            }
        }
        catch (Exception e) {
            return 255;
        }
        if (0 == dataSize) {
            return 0;
        }
        int i = offset + dataSize;
        if (0 > i) {
            return 255;
        }
        if (null == data || data.length < offset + dataSize) {
            return 1;
        }
        try {
            inStream = socket.getInputStream();
        }
        catch (Exception e) {
            return 3;
        }
        long startTime = System.currentTimeMillis();
        int readAble = 0;
        int requestReadSize = 0;
        while (true) {
            try {
                readAble = inStream.available();
            }
            catch (Exception e) {
                return 3;
            }
            if (0 < readAble) {
                requestReadSize = dataSize - readSize[0] < readAble ? dataSize - readSize[0] : readAble;
                try {
                    resultReadSize = inStream.read(data, offset + readSize[0], requestReadSize);
                }
                catch (Exception e) {
                    return 3;
                }
                if (0 < resultReadSize) break;
            }
            if (System.currentTimeMillis() - startTime > (long)timelimit) {
                return 4;
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                return 255;
            }
        }
        readSize[0] = readSize[0] + resultReadSize;
        if (readSize[0] >= dataSize) {
            return 0;
        }
        boolean retry = true;
        while (retry) {
            resultReadSize = 0;
            try {
                readAble = inStream.available();
            }
            catch (Exception e) {
                return 3;
            }
            if (0 >= readAble) break;
            requestReadSize = dataSize - readSize[0] < readAble ? dataSize - readSize[0] : readAble;
            try {
                resultReadSize = inStream.read(data, offset + readSize[0], requestReadSize);
            }
            catch (Exception e) {
                return 3;
            }
            if (0 >= resultReadSize) break;
            readSize[0] = readSize[0] + resultReadSize;
            if (readSize[0] < dataSize) continue;
            retry = false;
        }
        return 0;
    }

    private static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogInfoMethod = mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            mOutputLogInfoMethod.setAccessible(true);
            mBtPairedOkField = mClassOutputLog.getDeclaredField("LOGIF_OP_STR_BT_PAIRED_OK");
            mBtPairedOkField.setAccessible(true);
            mBtPairedOk = (String)mBtPairedOkField.get(null);
            mBtPairedNgField = mClassOutputLog.getDeclaredField("LOGIF_OP_STR_BT_PAIRED_NG");
            mBtPairedNgField.setAccessible(true);
            mBtPairedNg = (String)mBtPairedNgField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void outputLogInfo(Object ... param) {
        try {
            mOutputLogInfoMethod.invoke(mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            NetBt.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

