package com.gingersoft.coldchain_module.mvp.ui.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.coldchain_module.R;
import com.gingersoft.coldchain_module.mvp.model.bean.FoodDetailsTranBean;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static com.bin.david.form.utils.DensityUtils.dp2px;

public class OrderDetailsFoodAdapter extends BaseQuickAdapter<OrderDetails.DataBean.PRODUCTNAMEBean, BaseViewHolder> {

    public OrderDetailsFoodAdapter(@Nullable List<OrderDetails.DataBean.PRODUCTNAMEBean> data) {
        super(R.layout.cold_chain_food_item, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, OrderDetails.DataBean.PRODUCTNAMEBean bean) {
        baseViewHolder.setText(R.id.tv_food_name, bean.getPRODUCT_NAME());
        baseViewHolder.setText(R.id.tv_food_number, getContext().getString(R.string.count) + bean.getNum());
        baseViewHolder.setText(R.id.tv_food_price, getContext().getString(R.string.amount_unit) + bean.getPRICE());

        List<OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX> childBeanXList = bean.getChild();
        if (childBeanXList != null) {
            for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX : childBeanXList) {
                View foodChild = getChild(FoodDetailsTranBean.getByChildBeanX(childBeanX), 10);
                LinearLayout content = foodChild.findViewById(R.id.layout_food_content);
                List<OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean> childBeans = childBeanX.getChild();
                if (childBeans != null) {
                    for (OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX.ChildBean childBean : childBeanX.getChild()) {
                        content.addView(getChild(FoodDetailsTranBean.getByChildBean(childBean), 20));
                    }
                }
                ((LinearLayout)baseViewHolder.getView(R.id.layout_food_content)).addView(foodChild);
            }
        }
    }

    private View getChild(FoodDetailsTranBean child, int leftMargin) {
        View foodChildChild = LayoutInflater.from(getContext()).inflate(R.layout.cold_chain_food_item, null, false);
        ((TextView)foodChildChild.findViewById(R.id.tv_food_name)).setText(child.getPRODUCT_NAME());
        ((TextView)foodChildChild.findViewById(R.id.tv_food_number)).setText(getContext().getString(R.string.count) + child.getNum());
        ((TextView)foodChildChild.findViewById(R.id.tv_food_price)).setText(getContext().getString(R.string.amount_unit) + child.getPRICE());

        ImageView childNext = foodChildChild.findViewById(R.id.iv_food_item_next);
        childNext.setVisibility(View.VISIBLE);
        childNext.setPadding(dp2px(getContext(), leftMargin), 0, 0, 0);
        return foodChildChild;
    }

}
