package com.gingersoft.gsa.delivery_pick_mode.mvp.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.print.bean.PrjBean;
import com.gingersoft.gsa.cloud.print.bean.UpdateBean;
import com.gingersoft.gsa.delivery_pick_mode.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.math.BigDecimal;
import java.util.List;

public class PrjStateAdapter extends BaseQuickAdapter<PrjBean, BaseViewHolder> {

    private Context context;
    private int indentation;
    /**
     * 打印成功、打印失敗、飛單失敗的顏色
     */
    private int successColor, failColor, flyFailColor;

    public PrjStateAdapter(Context context, @Nullable List<PrjBean> data) {
        super(R.layout.item_prj_state, data);
        this.context = context;
        addChildClickViewIds(R.id.tv_prj_record_print_operation);
        successColor = ContextCompat.getColor(context, R.color.order_state4_color);
        failColor = ContextCompat.getColor(context, R.color.other_order_details_cancel_btn_color);
        flyFailColor = ContextCompat.getColor(context, R.color.bright_orange);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, PrjBean dataBean) {
        //食品組名稱
        baseViewHolder.setText(R.id.tv_prj_record_food_group_name, dataBean.getFoodGroupName());
        //食品名稱
        TextView foodName = baseViewHolder.getView(R.id.tv_prj_record_food_name);
        foodName.setText(dataBean.getProductName());
        //打印失敗原因
        TextView tvFailReason = baseViewHolder.getView(R.id.tv_prj_record_fail_reason);
        tvFailReason.setText(UpdateBean.getStateByCode(dataBean.getPrinterType()));
        //打印狀態
        foodName.setTextColor(Color.WHITE);
        if (dataBean.getPrinterType() == UpdateBean.ALREADY_PRINT) {
            //打印成功
            baseViewHolder.setBackgroundColor(R.id.tv_prj_record_food_name, successColor);
            tvFailReason.setText("");
        } else if (dataBean.getPrinterType() == UpdateBean.FAILED_PRINT) {
            //打印失敗
            if (dataBean.getPresence() == PrjBean.NOT_GENERATED_PRJ) {
                //未生成PRJ記錄
                baseViewHolder.setBackgroundColor(R.id.tv_prj_record_food_name, failColor);
                tvFailReason.setText("未生成打印記錄");
            } else if (dataBean.getPrinterDeviceId() == -1) {
                //打印機id為-1
                baseViewHolder.setBackgroundColor(R.id.tv_prj_record_food_name, failColor);
                tvFailReason.setText("未找到對應的打印機");
            } else if (TextUtil.isEmptyOrNullOrUndefined(dataBean.getPrintPosition())) {
                //沒有打印位置
                baseViewHolder.setBackgroundColor(R.id.tv_prj_record_food_name, failColor);
                tvFailReason.setText("未配置打印位置");
            } else if (TextUtil.isNotEmptyOrNullOrUndefined(dataBean.getFlyingSinglePosition()) && dataBean.getRequests() > PrjBean.REQUEST_COUNT_FLY) {
                //飛單位置不為空並且請求次數大於5此，說明飛單打印失敗
                baseViewHolder.setBackgroundColor(R.id.tv_prj_record_food_name, flyFailColor);
            }
        } else {
            baseViewHolder.setBackgroundColor(R.id.tv_prj_record_food_name, failColor);
        }
        //設置打印位置
        setPrintPosition(baseViewHolder, dataBean);
        //請求次數
        baseViewHolder.setText(R.id.tv_prj_record_print_count, String.valueOf(dataBean.getRequests() <= 0 ? 1 : dataBean.getRequests()));
        //設置縮進
        if (baseViewHolder.getAdapterPosition() == 0) {
            //只第一次測量一下
            indentation = new BigDecimal(foodName.getPaint().measureText("哈")).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
        }
        TextView tvFoodName = baseViewHolder.getView(R.id.tv_prj_record_food_name);
        if (dataBean.getParentId() != 0) {
            tvFoodName.setPadding(indentation, tvFoodName.getPaddingTop(), tvFoodName.getPaddingRight(), tvFoodName.getPaddingBottom());
        } else {
            tvFoodName.setPadding(0, tvFoodName.getPaddingTop(), tvFoodName.getPaddingRight(), tvFoodName.getPaddingBottom());
        }
    }

    private void setPrintPosition(@NotNull BaseViewHolder baseViewHolder, PrjBean dataBean) {
        TextView tvPrintPosition = baseViewHolder.getView(R.id.tv_prj_record_print_position);
        if (TextUtil.isNotEmptyOrNullOrUndefined(dataBean.getPrintPosition())) {
            //打印位置
            if (dataBean.getStatus() == PrjBean.PRJ_STATUS_CUT_PAPER) {
                tvPrintPosition.setText(dataBean.getPrintPosition() + "*");
            } else {
                tvPrintPosition.setText(dataBean.getPrintPosition());
            }
            if (TextUtil.isNotEmptyOrNullOrUndefined(dataBean.getFlyingSinglePosition())) {
                //打印位置+飛單位置
                tvPrintPosition.setText(tvPrintPosition.getText() + "/" + dataBean.getFlyingSinglePosition());
            }
        } else {
            tvPrintPosition.setText("");
        }
    }
}
